/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.header;

import com.google.common.collect.Lists;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.HeaderData;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.header.SashSelectionAdapter;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class DiagramHeaderComposite
extends Composite {
    private static final String WIDGET_DATA_STYLE_KEYSTYLE = "style";
    private static final String LABEL_CONTAINER_FORCED_STYLE_FORMAT_STRING = "background-color: %s!important;";
    private static final String LABEL_FORCED_STYLE_FORMAT_STRING = "background-color: %s !important; color: %s !important;";
    private static final String HEX_COLOR_FORMAT_STRING = "#%02X%02X%02X";
    private static final int DEFAULT_HEADER_LINE_HEIGHT = 18;
    private static int lineHeight;
    private static final int LEFT_RULER_WIDTH = 22;
    private static final Cursor DISABLED_CURSOR;
    private IDiagramWorkbenchPart part;
    private DDiagram dDiagram;
    private GraphicalViewer diagramViewer;
    private Composite headerSection;
    private PropertyChangeListener diagramPropertyListener;
    private PropertyChangeListener portPropertyListener;
    private ZoomListener zoomListener;
    private boolean isRulerVisible;
    private int xOrigin;
    private double zoom;
    private Sash sash;

    static {
        DISABLED_CURSOR = Cursors.NO;
    }

    public DiagramHeaderComposite(Composite parent, IDiagramWorkbenchPart part) {
        super(parent, 0);
        this.part = part;
        if (part instanceof DDiagramEditor) {
            this.dDiagram = (DDiagram)((DDiagramEditor)part).getRepresentation();
        }
        this.setLayoutData(new GridData(768));
        GridLayout verticalGridLayout = new GridLayout(1, true);
        verticalGridLayout.horizontalSpacing = 0;
        verticalGridLayout.marginHeight = 0;
        verticalGridLayout.marginWidth = 0;
        verticalGridLayout.verticalSpacing = 0;
        this.setLayout((Layout)verticalGridLayout);
        Color defaultSeparatorColor = VisualBindingManager.getDefault().getColorFromRGBValues(HeaderData.DEFAULT_SEPARATOR_BACKGROUND_COLOR);
        this.addLineSeparator(defaultSeparatorColor, false);
        this.headerSection = new Composite((Composite)this, 0);
        GridData gd = new GridData(768);
        gd.heightHint = DiagramHeaderComposite.getDiagramHeaderLineHeight();
        if (this.dDiagram != null && this.dDiagram.eIsSet((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_HeaderHeight())) {
            gd.heightHint = this.dDiagram.getHeaderHeight() * DiagramHeaderComposite.getDiagramHeaderLineHeight();
        }
        this.headerSection.setLayoutData((Object)gd);
        this.headerSection.setBackground(defaultSeparatorColor);
        this.headerSection.setCursor(DISABLED_CURSOR);
        this.addLineSeparator(defaultSeparatorColor, false);
        this.addLineSeparator(ColorConstants.lightGray, true);
        this.sash = new Sash(parent, 256);
        this.sash.setLayoutData((Object)new GridData(768));
        this.sash.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                int nbLines = DiagramHeaderComposite.this.getNbLinesNeeded();
                DiagramHeaderComposite.this.setHeaderHeight(DiagramHeaderComposite.getDiagramHeaderLineHeight() * nbLines);
                DiagramHeaderComposite.this.sash.setFocus();
            }
        });
        this.sash.addSelectionListener((SelectionListener)new SashSelectionAdapter(this, this.dDiagram));
    }

    public static int getDiagramHeaderLineHeight() {
        if (lineHeight == 0 && (lineHeight = SWTUtil.getDefaultFontTextHeight() + 1) < 18) {
            lineHeight = 18;
        }
        return lineHeight;
    }

    protected void addLineSeparator(Color color, boolean force) {
        Composite separator = new Composite((Composite)this, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 1;
        separator.setLayoutData((Object)gd);
        separator.setBackground(color);
        separator.setCursor(DISABLED_CURSOR);
        if (force) {
            String colorHex = String.format(HEX_COLOR_FORMAT_STRING, color.getRed(), color.getGreen(), color.getBlue());
            String newForcedStyle = String.format(LABEL_CONTAINER_FORCED_STYLE_FORMAT_STRING, colorHex);
            separator.setData(WIDGET_DATA_STYLE_KEYSTYLE, (Object)newForcedStyle);
        }
    }

    public void rebuildHeaderSection() {
        this.headerSection.setRedraw(false);
        try {
            for (Control child : Lists.newArrayList((Object[])this.headerSection.getChildren())) {
                child.dispose();
            }
            LinkedList<HeaderData> headerDatas = this.getHeaderData();
            int nbColumns = headerDatas.size() * 2;
            if (this.isRulerVisible) {
                ++nbColumns;
            }
            GridLayout layout = new GridLayout(nbColumns, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.headerSection.setLayout((Layout)layout);
            if (this.isRulerVisible) {
                this.createLabelInHeaderSection("", 22, VisualBindingManager.getDefault().getColorFromRGBValues(HeaderData.DEFAULT_SEPARATOR_BACKGROUND_COLOR), VisualBindingManager.getDefault().getLabelColorFromRGBValues(HeaderData.DEFAULT_LABEL_COLOR));
            }
            int previousXLocation = 0;
            int previousWidth = 0;
            for (HeaderData headerData : headerDatas) {
                int width;
                int xLocation = (int)((double)headerData.getXLocation() * this.zoom);
                if (xLocation + (width = (int)((double)headerData.getWidth() * this.zoom)) <= this.xOrigin) continue;
                if (xLocation < this.xOrigin) {
                    width -= this.xOrigin - xLocation;
                    xLocation = 0;
                } else {
                    xLocation -= this.xOrigin;
                }
                int blankWidth = xLocation - (previousXLocation + previousWidth);
                if (blankWidth > 0) {
                    this.createLabelInHeaderSection("", blankWidth, VisualBindingManager.getDefault().getColorFromRGBValues(HeaderData.DEFAULT_SEPARATOR_BACKGROUND_COLOR), VisualBindingManager.getDefault().getLabelColorFromRGBValues(HeaderData.DEFAULT_LABEL_COLOR));
                }
                Color backgroundColor = headerData.getBackgroundColor() == null ? VisualBindingManager.getDefault().getLabelColorFromRGBValues(HeaderData.DEFAULT_BACKGROUND_COLOR) : VisualBindingManager.getDefault().getLabelColorFromRGBValues(headerData.getBackgroundColor());
                Color labelColor = headerData.getLabelColor() == null ? VisualBindingManager.getDefault().getLabelColorFromRGBValues(HeaderData.DEFAULT_LABEL_COLOR) : VisualBindingManager.getDefault().getLabelColorFromRGBValues(headerData.getLabelColor());
                this.createLabelInHeaderSection(headerData.getName(), width, backgroundColor, labelColor);
                previousXLocation = xLocation;
                previousWidth = width;
            }
            this.layout(true, true);
        }
        finally {
            this.headerSection.setRedraw(true);
        }
    }

    private LinkedList<HeaderData> getHeaderData() {
        LinkedList headerDatas = new LinkedList();
        if (this.dDiagram != null) {
            for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(this.dDiagram.getDescription().eClass().getEPackage())) continue;
                headerDatas = diagramTypeDescriptor.getDiagramDescriptionProvider().getHeaderData(this.dDiagram);
                break;
            }
        }
        return headerDatas;
    }

    protected Label createLabelInHeaderSection(String text, int width, Color backgroundColor, Color labelColor) {
        Composite labelContainer = new Composite(this.headerSection, 0);
        GridData gd = new GridData(1040);
        gd.widthHint = width;
        labelContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        labelContainer.setLayout((Layout)gl);
        labelContainer.setBackground(backgroundColor);
        if (VisualBindingManager.getDefault().getColorFromRGBValues(HeaderData.DEFAULT_SEPARATOR_BACKGROUND_COLOR) != backgroundColor) {
            String colorHex = String.format(HEX_COLOR_FORMAT_STRING, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
            String newForcedStyle = String.format(LABEL_CONTAINER_FORCED_STYLE_FORMAT_STRING, colorHex);
            labelContainer.setData(WIDGET_DATA_STYLE_KEYSTYLE, (Object)newForcedStyle);
        }
        final Label label = new Label(labelContainer, 0x1000140);
        label.setText(text);
        label.setToolTipText(text);
        label.setCursor(DISABLED_CURSOR);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setBackground(backgroundColor);
        label.setForeground(labelColor);
        if (!StringUtil.isEmpty((String)text)) {
            String colorHex = String.format(HEX_COLOR_FORMAT_STRING, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
            String labelColorHex = String.format(HEX_COLOR_FORMAT_STRING, labelColor.getRed(), labelColor.getGreen(), labelColor.getBlue());
            String newForcedStyle = String.format(LABEL_FORCED_STYLE_FORMAT_STRING, colorHex, labelColorHex);
            label.setData(WIDGET_DATA_STYLE_KEYSTYLE, (Object)newForcedStyle);
        }
        labelContainer.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                String truncatedText;
                String currentText = label.getText();
                if (!currentText.equals(truncatedText = SWTUtil.shortenText((String)label.getToolTipText(), (Control)label, (int)DiagramHeaderComposite.getDiagramHeaderLineHeight()))) {
                    label.setText(truncatedText);
                    label.getParent().layout();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        return label;
    }

    private int getNbLinesNeeded() {
        int maxNbLines = 1;
        Control[] headerLabels = this.headerSection.getChildren();
        int i = 0;
        while (i < headerLabels.length) {
            Label label = (Label)((Composite)headerLabels[i]).getChildren()[0];
            int nbLines = this.getNbLines(label.getToolTipText(), headerLabels[i]);
            if (maxNbLines < nbLines) {
                maxNbLines = nbLines;
            }
            ++i;
        }
        return maxNbLines;
    }

    private int getNbLines(String text, Control control) {
        int maxWidth = control.getBounds().width;
        return SWTUtil.getNbLines((Control)control, (String)text, (int)maxWidth);
    }

    public void setGraphicalViewer(ScrollingGraphicalViewer primaryViewer) {
        Assert.isNotNull((Object)primaryViewer);
        Assert.isNotNull((Object)primaryViewer.getControl());
        Assert.isTrue((this.diagramViewer == null ? 1 : 0) != 0);
        this.diagramViewer = primaryViewer;
        this.diagramPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("ruler$visibility".equals(property)) {
                    DiagramHeaderComposite.this.setRulerVisibility((Boolean)DiagramHeaderComposite.this.diagramViewer.getProperty("ruler$visibility"));
                }
            }
        };
        this.diagramViewer.addPropertyChangeListener(this.diagramPropertyListener);
        Viewport port = ((FigureCanvas)this.diagramViewer.getControl()).getViewport();
        this.portPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("viewLocation".equals(property) && evt.getSource() instanceof Viewport) {
                    Viewport viewport = (Viewport)evt.getSource();
                    DiagramHeaderComposite.this.xOrigin = viewport.getHorizontalRangeModel().getValue();
                }
                DiagramHeaderComposite.this.rebuildHeaderSection();
            }
        };
        port.addPropertyChangeListener(this.portPropertyListener);
        ZoomManager zoomManager = (ZoomManager)this.part.getDiagramEditPart().getViewer().getProperty(ZoomManager.class.toString());
        this.zoomListener = new ZoomListener(){

            public void zoomChanged(double newZoom) {
                DiagramHeaderComposite.this.zoom = newZoom;
                DiagramHeaderComposite.this.rebuildHeaderSection();
            }
        };
        zoomManager.addZoomListener(this.zoomListener);
        this.xOrigin = port.getHorizontalRangeModel().getValue();
        this.zoom = zoomManager.getZoom();
        Boolean rulerVisibility = (Boolean)this.diagramViewer.getProperty("ruler$visibility");
        if (rulerVisibility != null) {
            this.setRulerVisibility(rulerVisibility);
        }
    }

    private void setRulerVisibility(boolean isVisible) {
        if (this.isRulerVisible != isVisible) {
            this.isRulerVisible = isVisible;
            this.rebuildHeaderSection();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.part != null) {
            ZoomManager zoomManager = (ZoomManager)this.part.getDiagramEditPart().getViewer().getProperty(ZoomManager.class.toString());
            zoomManager.removeZoomListener(this.zoomListener);
        }
        if (this.diagramViewer != null) {
            Viewport port = ((FigureCanvas)this.diagramViewer.getControl()).getViewport();
            port.removePropertyChangeListener(this.portPropertyListener);
            this.diagramViewer.removePropertyChangeListener(this.diagramPropertyListener);
        }
        Listener[] selectionListener = this.sash.getListeners(13);
        int i = 0;
        while (i < selectionListener.length) {
            this.sash.removeSelectionListener((SelectionListener)selectionListener[i]);
            ++i;
        }
        this.sash.dispose();
        this.sash = null;
        this.part = null;
        this.dDiagram = null;
        this.diagramViewer = null;
    }

    public Composite getHeaderSection() {
        return this.headerSection;
    }

    public void setHeaderHeight(int newHeight) {
        GridData gridData = (GridData)this.getHeaderSection().getLayoutData();
        int currentHeightHint = gridData.heightHint;
        if (currentHeightHint != newHeight) {
            gridData.heightHint = newHeight;
            this.getParent().layout(true, true);
            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.dDiagram);
            ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)this.dDiagram, (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_HeaderHeight(), (Object)(newHeight / DiagramHeaderComposite.getDiagramHeaderLineHeight())));
        }
    }
}

