/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.profiler.view;

import java.text.Collator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerEvent;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerListener;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.tools.api.profiler.InitProfilerAction;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfilerTreeViewContentProvider;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfilerTreeViewLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfilerViewItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class TimeProfilerTreeView
extends ViewPart
implements ProfilerListener {
    private TreeViewer viewer;
    private InitProfilerAction initProfilerAction;
    private IAction refreshAction;
    private IAction printAction;
    private ViewerSorter categorySorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            if (e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem) {
                String category1 = ((TimeProfilerViewItem)e1).getTask().getCategory();
                String category2 = ((TimeProfilerViewItem)e2).getTask().getCategory();
                return Collator.getInstance().compare(category1, category2);
            }
            return super.compare(v, e1, e2);
        }
    };
    private ViewerSorter nameSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            if (e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem) {
                String task1 = ((TimeProfilerViewItem)e1).getTask().getName();
                String task2 = ((TimeProfilerViewItem)e2).getTask().getName();
                return Collator.getInstance().compare(task1, task2);
            }
            return super.compare(v, e1, e2);
        }
    };
    private ViewerSorter timeSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            long time2;
            long time1;
            long tmp;
            int comparison = e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem ? ((tmp = (time1 = ((TimeProfilerViewItem)e1).getTime().longValue()) - (time2 = ((TimeProfilerViewItem)e2).getTime().longValue())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)) : super.compare(v, e1, e2);
            return comparison;
        }
    };
    private ViewerSorter occurencesSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            long occurences2;
            int occurences1;
            long tmp;
            int comparison = e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem ? ((tmp = (long)(occurences1 = ((TimeProfilerViewItem)e1).getOccurences().intValue()) - (occurences2 = (long)((TimeProfilerViewItem)e2).getOccurences().intValue())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)) : super.compare(v, e1, e2);
            return comparison;
        }
    };
    private InverseViewerSorter inverseSorter = new InverseViewerSorter();

    public TimeProfilerTreeView() {
        DslCommonPlugin.PROFILER.addProfilerListener((ProfilerListener)this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        String[] columnNames = new String[]{Messages.TimeProfiler_column_category, Messages.TimeProfiler_column_task, Messages.TimeProfiler_column_time, Messages.TimeProfiler_column_occ};
        int[] columnWidths = new int[]{100, 100, 100, 100};
        int[] columnAlignments = new int[]{16384, 16384, 131072, 131072};
        int i = 0;
        while (i < columnNames.length) {
            TreeViewerColumn treeColumn = new TreeViewerColumn(this.viewer, columnAlignments[i]);
            treeColumn.getColumn().setText(columnNames[i]);
            treeColumn.getColumn().setWidth(columnWidths[i]);
            final int index = i++;
            treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeProfilerTreeView.this.setSorter(index);
                }
            });
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new TimeProfilerTreeViewLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TimeProfilerTreeViewContentProvider());
        this.createActions();
        this.createContextMenu();
        this.createToolbarButtons();
        this.viewer.setInput((Object)TreeItemWrapper.ROOT_ITEM);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void taskStarted(ProfilerEvent event) {
    }

    public void taskStopped(ProfilerEvent event) {
    }

    private void createActions() {
        this.initProfilerAction = new InitProfilerAction(this.viewer);
        this.initProfilerAction.setText(Messages.TimeProfiler_action_reinit);
        this.refreshAction = new Action(){

            public void run() {
                TimeProfilerTreeView.this.viewer.refresh();
            }
        };
        this.refreshAction.setText(Messages.TimeProfiler_action_refresh);
        this.printAction = new Action(){

            public void run() {
                System.out.println(DslCommonPlugin.PROFILER.getStatus());
            }
        };
        this.printAction.setText(Messages.TimeProfiler_action_print);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TimeProfilerTreeView.this.fillContextMenu(manager);
            }
        });
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.initProfilerAction);
        menuManager.add(this.refreshAction);
        menuManager.add(this.printAction);
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void createToolbarButtons() {
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.initProfilerAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.refreshAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.printAction);
    }

    public void profilerReinited(ProfilerEvent event) {
        this.viewer.refresh();
    }

    private void setSorter(int column) {
        switch (column) {
            case 0: {
                if (this.viewer.getSorter() != this.categorySorter) {
                    this.viewer.setSorter(this.categorySorter);
                    break;
                }
                this.inverseSorter.setSorter(this.categorySorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 1: {
                if (this.viewer.getSorter() != this.nameSorter) {
                    this.viewer.setSorter(this.nameSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.nameSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 2: {
                if (this.viewer.getSorter() != this.timeSorter) {
                    this.viewer.setSorter(this.timeSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.timeSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 3: {
                if (this.viewer.getSorter() != this.occurencesSorter) {
                    this.viewer.setSorter(this.occurencesSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.occurencesSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
        }
    }

    private static final class InverseViewerSorter
    extends ViewerSorter {
        private ViewerSorter sorter;

        private InverseViewerSorter() {
        }

        public void setSorter(ViewerSorter sorter) {
            this.sorter = sorter;
        }

        public int compare(Viewer v, Object e1, Object e2) {
            return this.sorter == null ? super.compare(v, e1, e2) : -this.sorter.compare(v, e1, e2);
        }
    }
}

