/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ISequenceNodeMoveOperation
extends AbstractModelChangeOperation<Void> {
    private final Collection<ISequenceNode> seqNodes = new HashSet<ISequenceNode>();
    private final int logicalShift;
    private final int horizontalShift;

    public ISequenceNodeMoveOperation(ISequenceNode node, int logicalShift) {
        super(Messages.ISequenceNodeMoveOperation_operationName);
        this.seqNodes.add(Objects.requireNonNull(node));
        this.logicalShift = logicalShift;
        this.horizontalShift = 0;
    }

    public ISequenceNodeMoveOperation(Collection<ISequenceNode> nodes, int logicalShift) {
        super(Messages.ISequenceNodeMoveOperation_operationName);
        Objects.requireNonNull(nodes);
        this.seqNodes.addAll(nodes);
        this.logicalShift = logicalShift;
        this.horizontalShift = 0;
    }

    public ISequenceNodeMoveOperation(Collection<ISequenceNode> nodes, int logicalShift, int horizontalShift) {
        super(Messages.ISequenceNodeMoveOperation_operationName);
        Objects.requireNonNull(nodes);
        this.seqNodes.addAll(nodes);
        this.logicalShift = logicalShift;
        this.horizontalShift = horizontalShift;
    }

    public Void execute() {
        for (ISequenceNode seqNode : this.seqNodes) {
            Node node = seqNode.getNotationNode();
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (!(layoutConstraint instanceof Location) || this.logicalShift == 0) continue;
            Location location = (Location)layoutConstraint;
            location.setY(location.getY() + this.logicalShift);
            if (this.horizontalShift == 0) continue;
            location.setX(location.getX() + this.horizontalShift);
        }
        return null;
    }
}

