/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import com.sun.ts.lib.harness.TSTestFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AssertionMapper {
    private static final String NO_DESC = "See assertion html documents.";
    private static final String INVALID = "WARN: invalid assertion_id: ";
    public static final String NL;
    public static final String NL2;
    private static boolean debug;
    private static boolean showRetrievedAssertions;
    protected static String assertionDir;
    private static String[] assertionFiles;
    private static Map fileName2Map;
    private static Map aMap;
    private static Set unloadable;

    private AssertionMapper() {
    }

    public static void main(String[] args) {
        String[] s = new String[]{"JMS:SPEC:130.3", "EJB:JAVADOC:27", "JMS:SPEC:130.19", "JSP:SPEC:130", "JMS:SPEC:130.9.5", "JMS:SPEC:130.9"};
        Arrays.sort(s, AssertionComparator.getInstance());
        System.out.println("After sorting");
        for (int i = 0; i < s.length; ++i) {
            System.out.println(s[i]);
        }
    }

    public static void log(String s) {
        System.out.println(s);
    }

    public static String getAssertionDescriptions(String assertionIds, File file) {
        String filePath = file.getPath();
        if (assertionIds == null || assertionIds.length() == 0) {
            System.out.println("WARN: no value for assertion_ids (" + filePath + ")");
            return NO_DESC;
        }
        StringTokenizer st = new StringTokenizer(assertionIds, ";,\n\r\f\t");
        int countId = st.countTokens();
        String[] idArray = new String[countId];
        for (int i = 0; i < idArray.length; ++i) {
            idArray[i] = st.nextToken().trim();
        }
        Arrays.sort(idArray, AssertionComparator.getInstance());
        HashSet addedAssertions = new HashSet();
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < idArray.length; ++i) {
            String aDescription = AssertionMapper.getDescription0(idArray[i], filePath, addedAssertions);
            if (aDescription == null || aDescription.length() <= 0) continue;
            retval.append(aDescription).append(NL2);
        }
        return retval.toString().trim();
    }

    private static String getDescription0(String token, String filePath, Set addedAssertions) {
        Object aDescription = null;
        int pos1 = token.indexOf(":");
        if (pos1 == -1) {
            System.out.println(INVALID + token + " (" + filePath + ")");
            return null;
        }
        String first = token.substring(0, pos1);
        int pos2 = token.indexOf(":", pos1 + 1);
        if (pos2 == -1) {
            System.out.println(INVALID + token + " (" + filePath + ")");
            return null;
        }
        String second = token.substring(pos1 + 1, pos2);
        String third = token.substring(pos2 + 1);
        StringBuffer xmlFileName = new StringBuffer();
        xmlFileName.append(first);
        xmlFileName.append(Character.toUpperCase(second.charAt(0)));
        xmlFileName.append(second.substring(1).toLowerCase());
        xmlFileName.append("Assertions.xml");
        String fn = xmlFileName.toString();
        Map assertionMap = (Map)fileName2Map.get(fn);
        if (assertionMap == null && !unloadable.contains(fn)) {
            new HelpHandler().load(fn, first);
        }
        assertionMap = (Map)fileName2Map.get(fn);
        StringBuffer resultBuffer = new StringBuffer();
        if (assertionMap == null) {
            resultBuffer.append(token).append("  ").append(NO_DESC);
            return resultBuffer.toString();
        }
        int dotPosition = token.indexOf(".", pos2);
        while (dotPosition != -1) {
            String upperId = token.substring(0, dotPosition);
            if (!addedAssertions.contains(upperId)) {
                String upperDesc = (String)assertionMap.get(upperId);
                if (upperDesc == null || upperDesc.length() == 0) {
                    System.out.println("WARN: no description for " + upperId + " in " + filePath);
                    upperDesc = NO_DESC;
                }
                resultBuffer.append(upperId).append("  ").append(upperDesc).append(NL2);
                addedAssertions.add(upperId);
            }
            dotPosition = token.indexOf(".", dotPosition + 1);
        }
        if (!addedAssertions.contains(token)) {
            String thisDescription = (String)assertionMap.get(token);
            if (thisDescription == null) {
                thisDescription = NO_DESC;
                System.out.println("WARN: no description for " + token + " in " + filePath);
            }
            resultBuffer.append(token).append("  ").append(thisDescription).append(NL2);
            addedAssertions.add(token);
        }
        ArrayList<String> keyList = new ArrayList<String>();
        String tokenDot = token + ".";
        for (String key : assertionMap.keySet()) {
            if (!key.startsWith(tokenDot) || addedAssertions.contains(key)) continue;
            keyList.add(key);
        }
        Collections.sort(keyList, AssertionComparator.getInstance());
        int n = keyList.size();
        for (int i = 0; i < n; ++i) {
            String k = (String)keyList.get(i);
            resultBuffer.append(k).append("  ").append(assertionMap.get(k)).append(NL2);
            addedAssertions.add(k);
        }
        return resultBuffer.toString().trim();
    }

    static {
        NL2 = NL = System.getProperty("line.separator");
        fileName2Map = new HashMap();
        aMap = new HashMap();
        unloadable = new HashSet();
        debug = Boolean.getBoolean("AssertionMapper.debug");
        showRetrievedAssertions = Boolean.getBoolean("show.retrieved.assertions");
        assertionDir = System.getProperty("assertion.dir");
        if (assertionDir == null) {
            assertionDir = TSTestFinder.TS_HOME + File.separator + "internal" + File.separator + "docs";
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(assertionDir);
        ds.addDefaultExcludes();
        ds.setCaseSensitive(false);
        ds.setIncludes(new String[]{"**/*Assertions.xml"});
        ds.scan();
        assertionFiles = ds.getIncludedFiles();
        System.out.println(assertionFiles.length + " assertion files under " + assertionDir);
        for (int i = 0; i < assertionFiles.length; ++i) {
            System.out.println(assertionFiles[i]);
        }
    }

    public static class AssertionComparator
    implements Comparator {
        private static AssertionComparator instance = new AssertionComparator();

        private AssertionComparator() {
        }

        public static AssertionComparator getInstance() {
            return instance;
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int pos1 = s1.lastIndexOf(":");
            int pos2 = s2.lastIndexOf(":");
            String word1 = null;
            String word2 = null;
            if (pos1 != -1) {
                word1 = s1.substring(0, pos1);
            }
            if (pos2 != -1) {
                word2 = s2.substring(0, pos2);
            }
            String numPart1 = null;
            String numPart2 = null;
            if (pos1 == -1 && pos2 == -1) {
                numPart1 = s1;
                numPart2 = s2;
            } else {
                if (word1 == null || word2 == null) {
                    return -1;
                }
                int wordCompare = word1.compareTo(word2);
                if (wordCompare != 0) {
                    return wordCompare;
                }
                numPart1 = s1.substring(pos1 + 1);
                numPart2 = s2.substring(pos2 + 1);
            }
            StringTokenizer st1 = new StringTokenizer(numPart1, ".");
            StringTokenizer st2 = new StringTokenizer(numPart2, ".");
            int size1 = st1.countTokens();
            int size2 = st2.countTokens();
            int biggerSize = size1 == size2 ? size1 : (size1 > size2 ? size1 : size2);
            int[] int1 = new int[biggerSize];
            int[] int2 = new int[biggerSize];
            this.fillIntArray(st1, int1);
            this.fillIntArray(st2, int2);
            for (int i = 0; i < biggerSize; ++i) {
                int diff = int1[i] - int2[i];
                if (diff != 0) {
                    return diff;
                }
                if (int1[i] != 0) continue;
                return -1;
            }
            return -1;
        }

        private void fillIntArray(StringTokenizer st, int[] int1) {
            for (int i = 0; i < int1.length && st.hasMoreTokens(); ++i) {
                try {
                    int1[i] = Integer.parseInt(st.nextToken());
                    continue;
                }
                catch (NumberFormatException exp) {
                    break;
                }
            }
        }
    }

    public static class HelpHandler
    extends HandlerBase {
        private String xmlFileName;
        private boolean b_assertions;
        private boolean b_assertion;
        private boolean b_id;
        private boolean b_description;
        private boolean b_technology;
        private String currentId;
        private String currentDescription;
        private String techType;
        private String specOrJavadoc;
        private Map aFileMap;
        private boolean alreadyPut;
        private String parentDir;

        public void load(String xmlFileName, String technologyName) {
            String fn = null;
            for (int i = 0; i < assertionFiles.length; ++i) {
                int index = assertionFiles[i].lastIndexOf(File.separator) + 1;
                String fName = assertionFiles[i].substring(index);
                if (!fName.equalsIgnoreCase(xmlFileName)) continue;
                fn = assertionFiles[i];
                break;
            }
            if (fn == null) {
                System.out.println("WARN: failed to find file " + xmlFileName + " under " + assertionDir + ", verify the technology name [" + technologyName + "] is spelled correcting in the test clients");
                return;
            }
            this.xmlFileName = xmlFileName;
            try {
                System.err.println("%%%%%%%%%% Parsing file \"" + fn + "\" %%%%%%%%%");
                File fileFN = new File(fn);
                this.parentDir = fileFN.getParent();
                System.err.println("%%%%%%%%%% parentDir set to (resolver uses this) \"" + this.parentDir + "\" %%%%%%%%%");
                InputSource is = new InputSource(new FileInputStream(new File(assertionDir, fn)));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (HandlerBase)this);
            }
            catch (SAXException se) {
                se.printStackTrace();
                unloadable.add(xmlFileName);
                System.out.println("Will skip all assertions in " + xmlFileName);
            }
            catch (IOException fe) {
                fe.printStackTrace();
                unloadable.add(xmlFileName);
                System.out.println("Will skip all assertions in " + xmlFileName);
            }
            catch (ParserConfigurationException pe) {
                pe.printStackTrace();
                unloadable.add(xmlFileName);
                System.out.println("Will skip all assertions in " + xmlFileName);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            System.err.println("publicId \"" + publicId + "\"");
            System.err.println("systemId \"" + systemId + "\"");
            Object result = null;
            String fileName = systemId.substring(systemId.lastIndexOf("/") + 1);
            String possibleLocation = assertionDir + File.separator + this.parentDir + File.separator + fileName;
            File possibleFile = new File(possibleLocation);
            if (possibleFile.isFile()) {
                result = possibleLocation;
            } else {
                System.err.println("%%%%%%% Error could not resolve file \"" + fileName + "\"");
                result = systemId;
            }
            System.err.println("%%%%%%%% Entity Resolver returning \"" + (String)result + "\"");
            return new InputSource((String)result);
        }

        @Override
        public void startElement(String localName, AttributeList attrs) throws SAXException {
            if (localName.equalsIgnoreCase("assertions")) {
                this.b_assertions = true;
                this.aFileMap = new HashMap();
            } else if (localName.equalsIgnoreCase("assertion") && this.b_assertions) {
                this.b_assertion = true;
            } else if (localName.equalsIgnoreCase("id") && this.b_assertions && this.b_assertion) {
                this.b_id = true;
            } else if (localName.equalsIgnoreCase("description") && this.b_assertions && this.b_assertion) {
                this.b_description = true;
            } else if (localName.equalsIgnoreCase("sub-assertions") && this.b_assertions && this.b_assertion) {
                this.putIdAndDescription();
            } else if (localName.equalsIgnoreCase("spec") || localName.equalsIgnoreCase("javadoc")) {
                this.specOrJavadoc = localName;
            } else if (localName.equalsIgnoreCase("technology")) {
                this.b_technology = true;
            }
        }

        @Override
        public void endElement(String localName) throws SAXException {
            if (localName.equalsIgnoreCase("assertions")) {
                fileName2Map.put(this.xmlFileName, this.aFileMap);
                this.b_assertions = false;
                return;
            }
            if (localName.equalsIgnoreCase("assertion")) {
                this.putIdAndDescription();
                this.b_assertion = false;
                this.b_id = false;
                this.b_description = false;
            } else if (localName.equalsIgnoreCase("id") && this.b_assertions && this.b_assertion) {
                this.b_id = false;
            } else if (localName.equalsIgnoreCase("description") && this.b_assertions && this.b_assertion) {
                this.b_description = false;
            } else if (localName.equalsIgnoreCase("technology")) {
                this.b_technology = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.b_id && this.b_description) {
                System.out.println("WARN: invalid state: in both id and description element.");
            }
            if (this.b_id) {
                this.currentId = new String(ch, start, length);
                this.alreadyPut = false;
            } else if (this.b_description) {
                String content = new String(ch, start, length);
                this.currentDescription = this.currentDescription == null ? content : this.currentDescription + " " + content;
                this.alreadyPut = false;
            } else if (this.b_technology) {
                if (this.specOrJavadoc == null) {
                    System.out.println("Should have encountered javadoc or spec element!");
                } else {
                    String tech = new String(ch, start, length).trim();
                    this.techType = (tech + ":" + this.specOrJavadoc).toUpperCase();
                }
            }
        }

        private void putIdAndDescription() {
            if (this.alreadyPut) {
                return;
            }
            if (this.currentId == null || this.currentId.length() == 0) {
                System.out.println("WARN: null id in " + this.xmlFileName);
                return;
            }
            this.currentId = this.currentId.trim();
            if (this.techType != null && !this.currentId.startsWith(this.techType)) {
                this.currentId = this.techType + ":" + this.currentId;
            }
            if (this.currentDescription == null || this.currentDescription.length() == 0) {
                System.out.println("WARN: for id:[" + this.currentId + "] null description in " + this.xmlFileName);
                this.currentDescription = AssertionMapper.NO_DESC;
            } else {
                this.currentDescription = this.currentDescription.trim();
            }
            if (showRetrievedAssertions) {
                System.out.println(this.currentId + "  " + this.currentDescription);
            }
            this.aFileMap.put(this.currentId, this.currentDescription);
            this.alreadyPut = true;
            this.currentId = null;
            this.currentDescription = null;
        }
    }
}

