/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

class TestSuiteErrorsDialog
extends ToolDialog {
    private TestSuite testSuite;
    private JEditorPane body;

    TestSuiteErrorsDialog(Component parent, UIFactory uif) {
        super(parent, uif, "tse");
    }

    public void show(TestSuite ts) {
        this.testSuite = ts;
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body style=\"font-family: SansSerif; font-size: 12pt\">");
        if (this.testSuite == null) {
            sb.append(this.uif.getI18NString("tse.head.noTestSuite"));
        } else {
            TestFinder tf = this.testSuite.getTestFinder();
            if (tf.getErrorCount() == 0) {
                sb.append(this.uif.getI18NString("tse.head.noErrs"));
            } else {
                sb.append(this.uif.getI18NString("tse.head.errs"));
                sb.append("<ul>");
                String[] errors = tf.getErrors();
                for (int i = 0; i < errors.length; ++i) {
                    sb.append("<li>");
                    sb.append(this.escape(errors[i]));
                }
                sb.append("</ul>");
            }
        }
        sb.append("</body>");
        sb.append("</html>");
        if (this.body == null) {
            this.initGUI();
        }
        this.body.setText(sb.toString());
        this.setVisible(true);
    }

    @Override
    protected void initGUI() {
        this.setHelp("browse.testSuiteErrors.csh");
        this.setI18NTitle("tse.title");
        this.body = new JEditorPane();
        this.body.setName("tse");
        this.body.setContentType("text/html");
        this.body.setEditable(false);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane sp = this.uif.createScrollPane(this.body);
        int dpi = this.uif.getDotsPerInch();
        sp.setPreferredSize(new Dimension(6 * dpi, 3 * dpi));
        this.setBody(sp);
        JButton helpBtn = this.uif.createHelpButton("tse.help", "browse.testSuiteErrors.csh");
        JButton closeBtn = this.uif.createCloseButton("tse.close");
        this.setButtons(new JButton[]{helpBtn, closeBtn}, closeBtn);
    }

    private String escape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuffer sb = new StringBuffer(s.length() * 2);
                    block9: for (int j = 0; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        switch (c) {
                            case '<': {
                                sb.append("&lt;");
                                continue block9;
                            }
                            case '>': {
                                sb.append("&gt;");
                                continue block9;
                            }
                            case '&': {
                                sb.append("&amp;");
                                continue block9;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                    }
                    return sb.toString();
                }
            }
        }
        return s;
    }
}

