/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class ExcludeListUpdateHandler {
    private File localFile;
    private long localFileLastModified;
    private URL remoteURL;
    private long remoteURLLastModified;

    public ExcludeListUpdateHandler(URL remoteURL, File localFile) {
        if (remoteURL == null || localFile == null) {
            throw new NullPointerException();
        }
        this.remoteURL = remoteURL;
        this.localFile = localFile;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public long getLocalFileLastModified() {
        if (this.localFileLastModified == 0L) {
            this.localFileLastModified = this.localFile.lastModified();
        }
        return this.localFileLastModified;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public long getRemoteURLLastModified() throws IOException {
        if (this.remoteURLLastModified == 0L) {
            URLConnection c = this.remoteURL.openConnection();
            c.connect();
            this.remoteURLLastModified = c.getLastModified();
            c.getInputStream().close();
        }
        return this.remoteURLLastModified;
    }

    public boolean isUpdateAvailable() throws IOException {
        this.getLocalFileLastModified();
        this.getRemoteURLLastModified();
        return this.remoteURLLastModified > this.localFileLastModified;
    }

    public void update() throws IOException {
        this.update(this.remoteURL.openConnection());
    }

    public void updateIfNewer() throws IOException {
        URLConnection c = this.remoteURL.openConnection();
        c.getContentLength();
        c.connect();
        this.remoteURLLastModified = c.getLastModified();
        if (this.remoteURLLastModified > this.getLocalFileLastModified()) {
            this.update(c);
        } else {
            c.getInputStream().close();
        }
    }

    private void update(URLConnection c) throws IOException {
        int n;
        c.connect();
        int totalBytes = c.getContentLength();
        BufferedInputStream in = new BufferedInputStream(c.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.localFile));
        int bytesSoFar = 0;
        byte[] data = new byte[4096];
        while ((n = ((InputStream)in).read(data)) != -1) {
            ((OutputStream)out).write(data, 0, n);
            int n2 = Math.max((bytesSoFar += n) * 100 / totalBytes, 100);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

