/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONField
implements Serializable {
    private static final long serialVersionUID = -1397826405959590851L;
    private final JSONValue value;
    private final String name;

    public JSONField(String name, JSONValue value) {
        Validator.ensureNotNull(name);
        Validator.ensureNotNull(value);
        this.name = name;
        this.value = value;
    }

    public JSONField(String name, boolean value) {
        this(name, value ? JSONBoolean.TRUE : JSONBoolean.FALSE);
    }

    public JSONField(String name, long value) {
        this(name, new JSONNumber(value));
    }

    public JSONField(String name, double value) {
        this(name, new JSONNumber(value));
    }

    public JSONField(String name, String value) {
        this(name, new JSONString(value));
    }

    public String getName() {
        return this.name;
    }

    public JSONValue getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONField) {
            JSONField f = (JSONField)o;
            return this.name.equals(f.name) && this.value.equals(f.value);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        JSONString.encodeString(this.name, buffer);
        buffer.append(':');
        this.value.toString(buffer);
    }
}

