/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetEntryLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck
implements Serializable {
    private static final long DEFAULT_MAX_RESPONSE_TIME = 30000L;
    private static final long serialVersionUID = -3400259782503254645L;
    private final boolean invokeForBackgroundChecks;
    private final boolean invokeOnCheckout;
    private final boolean invokeOnCreate;
    private final boolean invokeOnException;
    private final boolean invokeOnRelease;
    private final long maxResponseTime;
    private final SearchRequest searchRequest;
    private final String entryDN;

    public GetEntryLDAPConnectionPoolHealthCheck(String entryDN, long maxResponseTime, boolean invokeOnCreate, boolean invokeOnCheckout, boolean invokeOnRelease, boolean invokeForBackgroundChecks, boolean invokeOnException) {
        this.invokeOnCreate = invokeOnCreate;
        this.invokeOnCheckout = invokeOnCheckout;
        this.invokeOnRelease = invokeOnRelease;
        this.invokeForBackgroundChecks = invokeForBackgroundChecks;
        this.invokeOnException = invokeOnException;
        this.entryDN = entryDN == null ? "" : entryDN;
        this.maxResponseTime = maxResponseTime > 0L ? maxResponseTime : 30000L;
        this.searchRequest = new SearchRequest(this.entryDN, SearchScope.BASE, Filter.createPresenceFilter("objectClass"), "1.1");
        this.searchRequest.setResponseTimeoutMillis(this.maxResponseTime);
    }

    @Override
    public void ensureNewConnectionValid(LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCreate) {
            this.getEntry(connection);
        }
    }

    @Override
    public void ensureConnectionValidForCheckout(LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCheckout) {
            this.getEntry(connection);
        }
    }

    @Override
    public void ensureConnectionValidForRelease(LDAPConnection connection) throws LDAPException {
        if (this.invokeOnRelease) {
            this.getEntry(connection);
        }
    }

    @Override
    public void ensureConnectionValidForContinuedUse(LDAPConnection connection) throws LDAPException {
        if (this.invokeForBackgroundChecks) {
            this.getEntry(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterException(LDAPConnection connection, LDAPException exception) throws LDAPException {
        super.ensureConnectionValidAfterException(connection, exception);
        if (this.invokeOnException) {
            this.getEntry(connection);
        }
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public long getMaxResponseTimeMillis() {
        return this.maxResponseTime;
    }

    public boolean invokeOnCreate() {
        return this.invokeOnCreate;
    }

    public boolean invokeOnCheckout() {
        return this.invokeOnCheckout;
    }

    public boolean invokeOnRelease() {
        return this.invokeOnRelease;
    }

    public boolean invokeForBackgroundChecks() {
        return this.invokeForBackgroundChecks;
    }

    public boolean invokeOnException() {
        return this.invokeOnException;
    }

    private void getEntry(LDAPConnection conn) throws LDAPException {
        try {
            SearchResult result = conn.search(this.searchRequest.duplicate());
            if (result.getEntryCount() != 1) {
                throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, LDAPMessages.ERR_GET_ENTRY_HEALTH_CHECK_NO_ENTRY_RETURNED.get());
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            String msg = LDAPMessages.ERR_GET_ENTRY_HEALTH_CHECK_FAILURE.get(this.entryDN, StaticUtils.getExceptionMessage(e));
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, msg, e);
            throw new LDAPException(ResultCode.SERVER_DOWN, msg, e);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GetEntryLDAPConnectionPoolHealthCheck(entryDN='");
        buffer.append(this.entryDN);
        buffer.append("', maxResponseTimeMillis=");
        buffer.append(this.maxResponseTime);
        buffer.append(", invokeOnCreate=");
        buffer.append(this.invokeOnCreate);
        buffer.append(", invokeOnCheckout=");
        buffer.append(this.invokeOnCheckout);
        buffer.append(", invokeOnRelease=");
        buffer.append(this.invokeOnRelease);
        buffer.append(", invokeForBackgroundChecks=");
        buffer.append(this.invokeForBackgroundChecks);
        buffer.append(", invokeOnException=");
        buffer.append(this.invokeOnException);
        buffer.append(')');
    }
}

