/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NumericStringMatchingRule
extends SimpleMatchingRule {
    private static final NumericStringMatchingRule INSTANCE = new NumericStringMatchingRule();
    public static final String EQUALITY_RULE_NAME = "numericStringMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("numericStringMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.8";
    public static final String ORDERING_RULE_NAME = "numericStringOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("numericStringOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.9";
    public static final String SUBSTRING_RULE_NAME = "numericStringSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("numericStringSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.10";
    private static final long serialVersionUID = -898484312052746321L;

    public static NumericStringMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    @Override
    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    @Override
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        int numSpaces = 0;
        byte[] valueBytes = value.getValue();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (valueBytes[i] == 32) {
                ++numSpaces;
                continue;
            }
            if (valueBytes[i] >= 48 && valueBytes[i] <= 57) continue;
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_NUMERIC_STRING_INVALID_CHARACTER.get(i));
        }
        if (numSpaces == 0) {
            return value;
        }
        int pos = 0;
        byte[] returnBytes = new byte[valueBytes.length - numSpaces];
        for (byte b : valueBytes) {
            if (b == 32) continue;
            returnBytes[pos++] = b;
        }
        return new ASN1OctetString(returnBytes);
    }

    @Override
    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        return this.normalize(value);
    }
}

