/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.nosql;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.Connection;
import jakarta.resource.cci.Interaction;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.Record;
import jakarta.resource.cci.ResourceWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.KeyValueVersion;
import oracle.kv.Operation;
import oracle.kv.OperationResult;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLConnection;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLOperation;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLRecord;

public class OracleNoSQLInteraction
implements Interaction {
    protected OracleNoSQLConnection connection;

    public OracleNoSQLInteraction(OracleNoSQLConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        throw ValidationException.operationNotSupported((String)"execute(InteractionSpec, jakarta.resource.cci.Record, jakarta.resource.cci.Record)");
    }

    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        block27: {
            if (!(spec instanceof OracleNoSQLInteractionSpec)) {
                throw EISException.invalidInteractionSpecType();
            }
            if (!(record instanceof OracleNoSQLRecord)) {
                throw EISException.invalidRecordType();
            }
            OracleNoSQLInteractionSpec noSqlSpec = (OracleNoSQLInteractionSpec)spec;
            OracleNoSQLRecord input = (OracleNoSQLRecord)record;
            try {
                OracleNoSQLOperation operation = noSqlSpec.getOperation();
                if (operation == OracleNoSQLOperation.GET) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey(this.createMajorKey(entry.getKey()));
                        SortedMap values = this.connection.getStore().multiGet(key, null, null, noSqlSpec.getConsistency(), noSqlSpec.getTimeout(), TimeUnit.MILLISECONDS);
                        if (values == null || values.isEmpty()) continue;
                        if (values.size() == 1) {
                            byte[] bytes = ((ValueVersion)values.values().iterator().next()).getValue().toByteArray();
                            output.put(entry.getKey(), this.convertBytes(bytes));
                            continue;
                        }
                        OracleNoSQLRecord nestedRecord = new OracleNoSQLRecord();
                        for (Map.Entry nestedEntry : values.entrySet()) {
                            byte[] bytes = ((ValueVersion)nestedEntry.getValue()).getValue().toByteArray();
                            OracleNoSQLRecord currentNestedRecord = nestedRecord;
                            List minorPaths = ((Key)nestedEntry.getKey()).getMinorPath();
                            if (minorPaths.isEmpty()) {
                                output.put(entry.getKey(), this.convertBytes(bytes));
                                continue;
                            }
                            for (int index = 0; index < minorPaths.size() - 1; ++index) {
                                String path = (String)minorPaths.get(index);
                                Object nextNestedRecord = currentNestedRecord.get(path);
                                if (!(nextNestedRecord instanceof OracleNoSQLRecord)) {
                                    nextNestedRecord = new OracleNoSQLRecord();
                                    currentNestedRecord.put(path, nextNestedRecord);
                                }
                                currentNestedRecord = (OracleNoSQLRecord)nextNestedRecord;
                            }
                            currentNestedRecord.put(minorPaths.get(minorPaths.size() - 1), this.convertBytes(bytes));
                        }
                        output.put(entry.getKey(), nestedRecord);
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.ITERATOR) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey(this.createMajorKey(entry.getKey()));
                        Iterator values = this.connection.getStore().storeIterator(Direction.UNORDERED, 0, key, null, null, noSqlSpec.getConsistency(), noSqlSpec.getTimeout(), TimeUnit.MILLISECONDS);
                        List lastMajorPath = null;
                        OracleNoSQLRecord nestedRecord = null;
                        while (values.hasNext()) {
                            KeyValueVersion pair = (KeyValueVersion)values.next();
                            byte[] bytes = pair.getValue().toByteArray();
                            if (pair.getKey().getMinorPath().isEmpty()) {
                                output.put(pair.getKey().getMajorPath(), this.convertBytes(bytes));
                                continue;
                            }
                            if (lastMajorPath == null || !lastMajorPath.equals(pair.getKey().getMajorPath())) {
                                lastMajorPath = pair.getKey().getMajorPath();
                                nestedRecord = new OracleNoSQLRecord();
                                output.put(lastMajorPath, nestedRecord);
                            }
                            OracleNoSQLRecord currentNestedRecord = nestedRecord;
                            List minorPaths = pair.getKey().getMinorPath();
                            for (int index = 0; index < minorPaths.size() - 1; ++index) {
                                String path = (String)minorPaths.get(index);
                                Object nextNestedRecord = currentNestedRecord.get(path);
                                if (!(nextNestedRecord instanceof OracleNoSQLRecord)) {
                                    nextNestedRecord = new OracleNoSQLRecord();
                                    currentNestedRecord.put(path, nextNestedRecord);
                                }
                                currentNestedRecord = (OracleNoSQLRecord)nextNestedRecord;
                            }
                            currentNestedRecord.put(minorPaths.get(minorPaths.size() - 1), this.convertBytes(bytes));
                        }
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.PUT || operation == OracleNoSQLOperation.PUT_IF_ABSENT || operation == OracleNoSQLOperation.PUT_IF_PRESENT || operation == OracleNoSQLOperation.PUT_IF_VERSION) {
                    ArrayList<Operation> operations = new ArrayList<Operation>();
                    for (Map.Entry entry : input.entrySet()) {
                        Object inputValue = entry.getValue();
                        List<String> majorKeys = this.createMajorKey(entry.getKey());
                        ArrayList<String> minorKeys = new ArrayList<String>();
                        this.putValues(inputValue, majorKeys, minorKeys, noSqlSpec, operations);
                    }
                    List results = this.connection.getStore().execute(operations, noSqlSpec.getDurability(), noSqlSpec.getTimeout(), TimeUnit.MILLISECONDS);
                    for (OperationResult result : results) {
                        if (result.getSuccess()) continue;
                        throw new ResourceException("Attempt to put failed:" + input);
                    }
                    break block27;
                }
                if (operation == OracleNoSQLOperation.DELETE) {
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey(this.createMajorKey(entry.getKey()));
                        this.connection.getStore().multiDelete(key, null, null, noSqlSpec.getDurability(), noSqlSpec.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                    break block27;
                }
                if (operation == OracleNoSQLOperation.DELETE_IF_VERSION) {
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey(this.createMajorKey(entry.getKey()));
                        boolean success = this.connection.getStore().deleteIfVersion(key, noSqlSpec.getVersion(), null, noSqlSpec.getDurability(), noSqlSpec.getTimeout(), TimeUnit.MILLISECONDS);
                        if (success) continue;
                        throw new ResourceException("Attempt to delete key failed:" + input);
                    }
                    break block27;
                }
                throw new ResourceException("Invalid NoSQL operation:" + operation);
            }
            catch (Exception exception) {
                throw new ResourceException((Throwable)exception);
            }
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    protected List<String> createMajorKey(Object key) {
        ArrayList<String> majorKeys = null;
        if (key instanceof List) {
            majorKeys = (ArrayList<String>)key;
        } else {
            majorKeys = new ArrayList<String>();
            String keyString = key.toString();
            if (keyString.length() > 2 && keyString.charAt(0) == '[' && keyString.charAt(keyString.length() - 1) == ']') {
                int startIndex = 1;
                while (startIndex < keyString.length() - 1) {
                    int endIndex = keyString.indexOf(44, startIndex);
                    if (endIndex == -1) {
                        endIndex = keyString.length() - 1;
                    }
                    String nextKey = keyString.substring(startIndex, endIndex);
                    majorKeys.add(nextKey);
                    startIndex = endIndex + 1;
                }
            } else {
                majorKeys.add(keyString);
            }
        }
        return majorKeys;
    }

    protected void putValues(Object element, List<String> majorKeys, List<String> minorKeys, OracleNoSQLInteractionSpec spec, List<Operation> operations) {
        if (element instanceof Collection) {
            element = ((List)element).get(0);
            for (Map.Entry nestedEntry : ((Map)element).entrySet()) {
                ArrayList<String> nestedMinorKeys = new ArrayList<String>(minorKeys);
                nestedMinorKeys.add(nestedEntry.getKey().toString());
                this.putValues(nestedEntry.getValue(), majorKeys, nestedMinorKeys, spec, operations);
            }
        } else {
            Key key = Key.createKey(majorKeys, minorKeys);
            Value value = this.createValue(element);
            if (spec.getOperation() == OracleNoSQLOperation.PUT) {
                operations.add(this.connection.getStore().getOperationFactory().createPut(key, value));
            } else if (spec.getOperation() == OracleNoSQLOperation.PUT_IF_ABSENT) {
                operations.add(this.connection.getStore().getOperationFactory().createPutIfAbsent(key, value));
            } else if (spec.getOperation() == OracleNoSQLOperation.PUT_IF_PRESENT) {
                operations.add(this.connection.getStore().getOperationFactory().createPutIfPresent(key, value));
            } else if (spec.getOperation() == OracleNoSQLOperation.PUT_IF_VERSION) {
                operations.add(this.connection.getStore().getOperationFactory().createPutIfVersion(key, value, spec.getVersion()));
            }
        }
    }

    protected Value createValue(Object data) {
        if (data == null) {
            data = new byte[0];
        } else if (!(data instanceof byte[])) {
            if (!(data instanceof String)) {
                data = data.toString();
            }
            data = ((String)data).getBytes();
        }
        return Value.createValue((byte[])((byte[])data));
    }

    protected Object convertBytes(byte[] bytes) {
        if (bytes.length > 0 && bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length == 0) {
            return null;
        }
        return bytes;
    }
}

