/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.List;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AlgorithmHelper;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;

public class RadialLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree = 0.0;
    private double endDegree = Math.PI * 2;
    private boolean resize = false;
    private final TreeLayoutAlgorithm treeLayout = new TreeLayoutAlgorithm();

    @Deprecated
    public RadialLayoutAlgorithm(int style) {
        this();
        this.setResizing(style != 1);
    }

    public RadialLayoutAlgorithm() {
    }

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.treeLayout.internalApplyLayout();
        EntityLayout[] entities = this.context.getEntities();
        DisplayIndependentRectangle bounds = this.context.getBounds();
        this.computeRadialPositions(entities, bounds);
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        int insets = 4;
        bounds.x += (double)insets;
        bounds.y += (double)insets;
        bounds.width -= (double)(2 * insets);
        bounds.height -= (double)(2 * insets);
        AlgorithmHelper.fitWithinBounds(entities, bounds, this.resize);
    }

    private void computeRadialPositions(EntityLayout[] entities, DisplayIndependentRectangle bounds) {
        DisplayIndependentRectangle layoutBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        layoutBounds.x = bounds.x;
        layoutBounds.width = bounds.width;
        EntityLayout[] entityLayoutArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            EntityLayout element = entityLayoutArray[n2];
            DisplayIndependentPoint location = element.getLocation();
            double percenttheta = (location.x - layoutBounds.x) / layoutBounds.width;
            double distance = (location.y - layoutBounds.y) / layoutBounds.height;
            double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percenttheta;
            location.x = distance * Math.cos(theta);
            location.y = distance * Math.sin(theta);
            element.setLocation(location.x, location.y);
            ++n2;
        }
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        super.setLayoutContext(context);
        this.treeLayout.setLayoutContext(context);
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
        this.treeLayout.setResizing(this.resize);
    }

    @Deprecated(since="2.0", forRemoval=true)
    public static class Zest1
    extends TreeLayoutAlgorithm.Zest1 {
        private static final double MAX_DEGREES = Math.PI * 2;
        private double startDegree;
        private double endDegree;
        private final TreeLayoutAlgorithm.Zest1 treeLayout;
        private List roots;
        @Deprecated
        DisplayIndependentRectangle layoutBounds = null;

        @Deprecated
        public Zest1() {
            this(0);
        }

        @Deprecated
        public Zest1(int styles) {
            super(styles);
            this.treeLayout = new TreeLayoutAlgorithm.Zest1(styles);
            this.startDegree = 0.0;
            this.endDegree = Math.PI * 2;
        }

        @Override
        @Deprecated
        public void setLayoutArea(double x, double y, double width, double height) {
            throw new RuntimeException("Operation not implemented");
        }

        @Override
        @Deprecated
        protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
            return !continueous;
        }

        @Override
        @Deprecated
        protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
            this.layoutBounds = new DisplayIndependentRectangle(x, y, width, height);
            super.preLayoutAlgorithm(entitiesToLayout, relationshipsToConsider, x, y, width, height);
        }

        @Override
        @Deprecated
        protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
            this.roots = this.treeLayout.getRoots();
            this.computeRadialPositions(entitiesToLayout, this.layoutBounds);
            this.defaultFitWithinBounds(entitiesToLayout, this.layoutBounds);
            super.postLayoutAlgorithm(entitiesToLayout, relationshipsToConsider);
        }

        @Deprecated
        public void setRangeToLayout(double startDegree, double endDegree) {
            this.startDegree = startDegree;
            this.endDegree = endDegree;
        }

        @Deprecated
        protected void computeRadialPositions(InternalNode[] entities, DisplayIndependentRectangle bounds2) {
            DisplayIndependentRectangle bounds = new DisplayIndependentRectangle(this.getLayoutBounds(entities, true));
            bounds.height = bounds2.height;
            bounds.y = bounds2.y;
            InternalNode[] internalNodeArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode entity = internalNodeArray[n2];
                double percentTheta = (entity.getInternalX() - bounds.x) / bounds.width;
                double distance = (entity.getInternalY() - bounds.y) / bounds.height;
                double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percentTheta;
                double newX = distance * Math.cos(theta);
                double newY = distance * Math.sin(theta);
                entity.setInternalLocation(newX, newY);
                ++n2;
            }
        }

        @Override
        @Deprecated
        protected DisplayIndependentRectangle getLayoutBounds(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
            DisplayIndependentRectangle layoutBounds = super.getLayoutBounds(entitiesToLayout, includeNodeSize);
            DisplayIndependentPoint centerPoint = this.roots != null ? Zest1.determineCenterPoint(this.roots) : new DisplayIndependentPoint(layoutBounds.x + layoutBounds.width / 2.0, layoutBounds.y + layoutBounds.height / 2.0);
            double maxDistanceX = Math.max(Math.abs(layoutBounds.x + layoutBounds.width - centerPoint.x), Math.abs(centerPoint.x - layoutBounds.x));
            double maxDistanceY = Math.max(Math.abs(layoutBounds.y + layoutBounds.height - centerPoint.y), Math.abs(centerPoint.y - layoutBounds.y));
            return new DisplayIndependentRectangle(centerPoint.x - maxDistanceX, centerPoint.y - maxDistanceY, maxDistanceX * 2.0, maxDistanceY * 2.0);
        }

        private static DisplayIndependentPoint determineCenterPoint(List<InternalNode> roots) {
            double totalX = 0.0;
            double totalY = 0.0;
            for (InternalNode entity : roots) {
                totalX += entity.getInternalX();
                totalY += entity.getInternalY();
            }
            return new DisplayIndependentPoint(totalX / (double)roots.size(), totalY / (double)roots.size());
        }
    }
}

