/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSI1311
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1311(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        boolean isOneWayResponse = this.validator.isOneWayResponse(entryContext);
        Document docResponse = null;
        if (!isOneWayResponse) {
            docResponse = entryContext.getResponseDocument();
        }
        if (!isOneWayResponse && this.validator.isFault(docResponse)) {
            this.result = "passed";
        } else {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            Document docRequest = entryContext.getRequestDocument();
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(docRequest, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                this.result = "notApplicable";
            } else {
                try {
                    BindingOperation bindingOperation = match.getOperation();
                    Operation operation = null;
                    List extElem = binding.getExtensibilityElements();
                    for (Object o : extElem) {
                        SOAPBinding soapBinding;
                        if (!(o instanceof SOAPBinding) || "http://schemas.xmlsoap.org/soap/http".equals((soapBinding = (SOAPBinding)o).getTransportURI())) continue;
                        throw new AssertionFailException();
                    }
                    operation = bindingOperation.getOperation();
                    if (operation == null) {
                        throw new AssertionFailException();
                    }
                    if (isOneWayResponse) {
                        if (operation.getOutput() == null) {
                            throw new AssertionPassException();
                        }
                        throw new AssertionFailException();
                    }
                    NodeList soapBodyList = docResponse.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                    if (soapBodyList == null || soapBodyList.getLength() == 0) {
                        throw new AssertionFailException();
                    }
                    int i = 0;
                    while (i < soapBodyList.getLength()) {
                        Element nextBodyElem = (Element)soapBodyList.item(i);
                        Element soapMessageElement = XMLUtils.getFirstChild(nextBodyElem);
                        while (soapMessageElement != null) {
                            Message message = operation.getOutput().getMessage();
                            QName soapMessageQName = new QName(soapMessageElement.getNamespaceURI(), soapMessageElement.getLocalName());
                            if (message != null && soapMessageQName.equals(message.getQName())) {
                                throw new AssertionPassException();
                            }
                            soapMessageElement = XMLUtils.getNextSibling(soapMessageElement);
                        }
                        ++i;
                    }
                }
                catch (AssertionPassException assertionPassException) {
                    this.result = "passed";
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                }
            }
        }
        if (this.result == "failed") {
            this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

