/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.core.util.RegistryReader;

public class ResourceMappingFilterExtensionRegistry
extends RegistryReader {
    static final String EXTENSION_NAME = "resourceMappingFilter";
    static final String RESOURCE_MAPPING = "resourceMapping";
    static final String SOURCE_PATH = "source-path";
    private static ResourceMappingFilterExtensionRegistry instance = null;
    private static HashMap<String, Pattern> resourceMappingFilters = null;

    public ResourceMappingFilterExtensionRegistry() {
        super("org.eclipse.wst.common.modulecore.ui", EXTENSION_NAME);
    }

    public static ResourceMappingFilterExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new ResourceMappingFilterExtensionRegistry();
            instance.readRegistry();
        }
        return instance;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(RESOURCE_MAPPING)) {
            return false;
        }
        String sourcePath = element.getAttribute(SOURCE_PATH);
        if (sourcePath != null) {
            ResourceMappingFilterExtensionRegistry.addResourceMappingFilter(sourcePath);
        }
        return true;
    }

    private static void addResourceMappingFilter(String filterRegExp) {
        if (resourceMappingFilters == null) {
            resourceMappingFilters = new HashMap();
        }
        if (filterRegExp != null) {
            try {
                Pattern pattern = Pattern.compile(filterRegExp);
                resourceMappingFilters.put(filterRegExp, pattern);
            }
            catch (PatternSyntaxException e) {
                ModuleCoreUIPlugin.logError(e);
            }
        }
    }

    public static boolean shouldFilter(IPath path) {
        ResourceMappingFilterExtensionRegistry.getInstance();
        if (path != null) {
            String relativePath = path.makeRelative().toString();
            for (Pattern pattern : resourceMappingFilters.values()) {
                Matcher matcher = pattern.matcher(relativePath);
                if (matcher.matches()) {
                    return true;
                }
                Pattern childrenPattern = Pattern.compile(pattern.pattern() + "/.*");
                matcher = childrenPattern.matcher(relativePath);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldFilter(String path) {
        if (path != null) {
            return ResourceMappingFilterExtensionRegistry.shouldFilter((IPath)new Path(path));
        }
        return false;
    }

    public static String[] getResourceMappingFiltersRegularExpressions() {
        return resourceMappingFilters.keySet().toArray(new String[resourceMappingFilters.keySet().size()]);
    }

    public static Pattern[] getResourceMappingFiltersRelativePatterns() {
        return resourceMappingFilters.values().toArray(new Pattern[resourceMappingFilters.values().size()]);
    }
}

