/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.regex.Pattern;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;

public class PHPVarCommentContext
extends PHPDocTagContext {
    private static final String LABEL = "([a-zA-Z_\\\\u007F-\\\\uFFFF][a-zA-Z0-9_\\\\u007F-\\\\uFFFF]*)";
    private static final String TYPE_PART = "(([a-zA-Z_\\\\u007F-\\\\uFFFF][a-zA-Z0-9_\\\\u007F-\\\\uFFFF]*)|[\\[\\]|\\\\])";
    private static final String WHITESPACES = "([ \\n\\r\\t]+)";
    private static final Pattern VAR_COMMENT_PATTERN = Pattern.compile("^.*/[*]([ \\n\\r\\t]+)?@var([ \\n\\r\\t]+)([$]([a-zA-Z_\\\\u007F-\\\\uFFFF][a-zA-Z0-9_\\\\u007F-\\\\uFFFF]*)([ \\n\\r\\t]+)(([a-zA-Z_\\\\u007F-\\\\uFFFF][a-zA-Z0-9_\\\\u007F-\\\\uFFFF]*)|[\\[\\]|\\\\])*|(([a-zA-Z_\\\\u007F-\\\\uFFFF][a-zA-Z0-9_\\\\u007F-\\\\uFFFF]*)|[\\[\\]|\\\\])*)$", 34);

    @Override
    protected boolean isPHPTag(String tagName) {
        return false;
    }

    @Override
    protected boolean isValidStatementText() {
        return VAR_COMMENT_PATTERN.matcher(this.getStatementText()).matches();
    }

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        return "var".equalsIgnoreCase(this.getTagName());
    }

    @Override
    protected boolean isRightPartitionType() {
        return this.getCompanion().getPartitionType() == "org.eclipse.php.PHP_MULTI_LINE_COMMENT";
    }
}

