/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.internal.jvm.JVMAcceptor;
import org.eclipse.net4j.internal.jvm.JVMAcceptorManager;
import org.eclipse.net4j.internal.jvm.JVMConnector;
import org.eclipse.net4j.internal.jvm.JVMServerConnector;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class JVMClientConnector
extends JVMConnector {
    private JVMAcceptor acceptor;

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.CLIENT;
    }

    public JVMAcceptor getAcceptor() {
        return this.acceptor;
    }

    public String toString() {
        if (this.getUserID() == null) {
            return MessageFormat.format("JVMClientConnector[{0}]", this.getName());
        }
        return MessageFormat.format("JVMClientConnector[{1}@{0}]", this.getName(), this.getUserID());
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        String name = this.getName();
        this.acceptor = JVMAcceptorManager.INSTANCE.getAcceptor(name);
        if (this.acceptor == null) {
            throw new IllegalStateException("JVM acceptor not found: " + name);
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        JVMServerConnector peer = this.acceptor.handleAccept(this);
        this.setPeer(peer);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivateNoisy((Object)this.getPeer());
        super.doDeactivate();
    }
}

