/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.ui.wizard.project;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.util.Policy;
import org.eclipse.m2m.internal.qvt.oml.jdt.debug.ui.launch.DebugPDEMessages;
import org.eclipse.m2m.internal.qvt.oml.jdt.ui.wizard.project.PdeProjectIntegrationImpl;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.swt.widgets.Combo;

public class JdtProjectIntegrationImpl
extends PdeProjectIntegrationImpl {
    private static Map<String, Integer> fSeverityTable = new HashMap<String, Integer>(3);
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;

    static {
        fSeverityTable.put("ignore", 1);
        fSeverityTable.put("warning", 2);
        fSeverityTable.put("error", 3);
    }

    @Override
    public void setupProject(IProject project, NewProjectData data, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            super.setupProject(project, data, (IProgressMonitor)subMonitor.split(1));
            if (data.isCreateJava()) {
                org.eclipse.pde.internal.core.util.CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)subMonitor.split(1));
                IContainer srcContainer = this.getFolder(project, data.getSourceFolderName(), (IProgressMonitor)subMonitor.split(1));
                IContainer binContainer = this.getFolder(project, data.getOutFolderName(), (IProgressMonitor)subMonitor.split(1));
                IJavaProject javaProject = JavaCore.create((IProject)project);
                javaProject.setOutputLocation(binContainer.getFullPath(), (IProgressMonitor)subMonitor.split(1));
                subMonitor.subTask(DebugPDEMessages.Setup_SettingClasspath);
                IClasspathEntry[] entries = new IClasspathEntry[data.isPlugin() ? 3 : 1];
                if (data.isPlugin()) {
                    String executionEnvironment = data.getfExecutionEnv();
                    ClasspathComputer.setComplianceOptions((IJavaProject)javaProject, (String)executionEnvironment, (boolean)true);
                    entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
                    entries[1] = ClasspathComputer.createContainerEntry();
                }
                entries[entries.length - 1] = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                javaProject.setRawClasspath(entries, (IProgressMonitor)subMonitor.split(1));
                if (data.isDoGenerateClass()) {
                    this.generateTopLevelPluginClass((IProgressMonitor)subMonitor.split(1));
                }
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    public String getRequiredExecutionEnv(String executionEnv) {
        if (JdtProjectIntegrationImpl.getEEnv(executionEnv) == null) {
            return null;
        }
        return executionEnv;
    }

    private static IExecutionEnvironment getEEnv(String ee) {
        if (ee != null) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            return manager.getEnvironment(ee);
        }
        return null;
    }

    @Override
    protected void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
    }

    public String getClassField(String id, String suffix) {
        IStatus status;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JdtProjectIntegrationImpl.validatePackageName(buffer.toString());
                if (status.getSeverity() == 4) {
                    buffer.append(suffix.toLowerCase());
                }
                buffer.append(ch);
            }
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            status = JdtProjectIntegrationImpl.validatePackageName(buffer.toString());
            if (status.getSeverity() == 4) {
                buffer.append(suffix.toLowerCase());
            }
            buffer.append("." + Character.toUpperCase(token.charAt(0)) + token.substring(1) + suffix);
        }
        return buffer.toString();
    }

    public IStatus validateJavaTypeName(String name) {
        return JavaConventions.validateJavaTypeName((String)name.trim(), (String)"1.8", (String)"1.8", null);
    }

    public void fillExecutionEnvironments(Combo combo) {
        IExecutionEnvironment[] fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        Arrays.sort(fInstalledEEs, new Comparator<IExecutionEnvironment>(){

            @Override
            public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                return Policy.getComparator().compare(arg0.getId(), arg1.getId());
            }
        });
        String[] eeLabels = new String[fInstalledEEs.length];
        int i = 0;
        while (i < fInstalledEEs.length) {
            eeLabels[i] = fInstalledEEs[i].getId();
            ++i;
        }
        combo.setItems(eeLabels);
        combo.setText(JdtProjectIntegrationImpl.getDefaultEEName());
    }

    private static IStatus validatePackageName(String name) {
        return JavaConventions.validatePackageName((String)name, (String)"1.8", (String)"1.8");
    }

    private static String getDefaultEEName() {
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (defaultVM != null) {
            int i = 0;
            while (i < environments.length) {
                IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                    return environments[i].getId();
                }
                ++i;
            }
        }
        String defaultCC = "1.8";
        try {
            if (JavaModelUtil.class.getDeclaredField("VERSION_LATEST") != null) {
                defaultCC = JavaModelUtil.VERSION_LATEST;
            }
        }
        catch (Exception eeDefaultVM) {
            // empty catch block
        }
        if (defaultVM instanceof IVMInstall2) {
            defaultCC = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)defaultVM), (String)defaultCC);
        }
        int i = 0;
        while (i < environments.length) {
            String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environments[i]);
            if (defaultCC.endsWith(eeCompliance)) {
                return environments[i].getId();
            }
            ++i;
        }
        return "JavaSE-1.8";
    }
}

