/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.jspeditor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.jspeditor.ITestHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

class JavaElementHyperlink
implements IHyperlink,
ITestHyperlink {
    private final IRegion fRegion;
    private final IJavaElement fElement;

    public JavaElementHyperlink(IRegion region, IJavaElement element) {
        this.fRegion = region;
        this.fElement = element;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        IJavaElement element = this.determineJavaElement();
        if (element != null) {
            ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
            if (compilationUnit != null) {
                return NLS.bind((String)Messages.Hyperlink_Open_JavaType, (Object)compilationUnit.getElementName());
            }
            return Messages.Hyperlink_Open_JavaFile;
        }
        return Messages.Hyperlink_Open_JavaElement;
    }

    public void open() {
        try {
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)this.fElement);
            if (editor != null) {
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)this.fElement);
            }
        }
        catch (Exception e) {
            JSFUiPlugin.log(2, e.getMessage(), e);
        }
    }

    @Override
    public IJavaElement determineJavaElement() {
        return this.fElement;
    }
}

