/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;

public class JpaJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public void sessionStarted() {
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return context instanceof JavaContentAssistInvocationContext ? this.computeCompletionProposals((JavaContentAssistInvocationContext)context) : Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            return this.computeCompletionProposals_(context);
        }
        catch (RuntimeException runtimeException) {
            return Collections.emptyList();
        }
    }

    private List<ICompletionProposal> computeCompletionProposals_(JavaContentAssistInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return Collections.emptyList();
        }
        IFile file = this.getCorrespondingResource(cu);
        if (file == null) {
            return Collections.emptyList();
        }
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        HashBag rootStructureNodes = CollectionTools.hashBag((Iterable)jpaFile.getRootStructureNodes());
        if (rootStructureNodes.isEmpty()) {
            return Collections.emptyList();
        }
        CompletionContext cc = context.getCoreContext();
        char[] prefix = cc.getToken();
        Predicate<String> filter = this.buildPrefixFilter(prefix);
        int tokenKind = cc.getTokenKind();
        int tokenStart = cc.getTokenStart();
        int tokenEnd = cc.getTokenEnd();
        if (tokenStart == -1) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (JpaStructureNode structureNode : rootStructureNodes) {
            for (String s : this.buildCompletionProposals((JavaPersistentType)structureNode, context.getInvocationOffset(), filter)) {
                if (tokenKind == 2) {
                    proposals.add((ICompletionProposal)new CompletionProposal(s, tokenStart + 1, tokenEnd - tokenStart - 1, s.length()));
                    continue;
                }
                proposals.add((ICompletionProposal)new CompletionProposal("\"" + s + "\"", tokenStart, tokenEnd - tokenStart + 1, s.length() + 2));
            }
        }
        return proposals;
    }

    private Iterable<String> buildCompletionProposals(JavaPersistentType structureNode, int pos, Predicate<String> filter) {
        return IterableTools.filter((Iterable)structureNode.getCompletionProposals(pos), filter);
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return null;
        }
    }

    private JpaFile getJpaFile(IFile file) {
        return (JpaFile)file.getAdapter(JpaFile.class);
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    private Predicate<String> buildPrefixFilter(char[] prefix) {
        return prefix == null ? PredicateTools.true_() : new StringTools.StartsWithIgnoreCase(new String(prefix));
    }
}

