/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class Arc
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    public static final int ARC = 1;
    public static final int ARCTO = 2;
    public static final int PIE = 3;
    public static final int CHORD = 4;
    private static final int EMF_BOX_OFFSET = 0;
    private static final int EMF_START_OFFSET = 16;
    private static final int EMF_END_OFFSET = 24;
    private static final int WMF_Y_END_OFFSET = 0;
    private static final int WMF_X_END_OFFSET = 2;
    private static final int WMF_Y_START_OFFSET = 4;
    private static final int WMF_X_START_OFFSET = 6;
    private static final int WMF_BOTTOM_OFFSET = 8;
    private static final int WMF_RIGHT_OFFSET = 10;
    private static final int WMF_TOP_OFFSET = 12;
    private static final int WMF_LEFT_OFFSET = 14;
    private int m_type = 1;
    private Rectangle m_box = new Rectangle();
    private Point m_start = new Point(0, 0);
    private Point m_end = new Point(0, 0);

    public Arc(int type) {
        this.m_type = type;
    }

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        short xStart = rec.getShortAt(6);
        short yStart = rec.getShortAt(4);
        short xEnd = rec.getShortAt(2);
        short yEnd = rec.getShortAt(0);
        short xBound = rec.getShortAt(14);
        short yBound = rec.getShortAt(12);
        short x1Bound = rec.getShortAt(10);
        short y1Bound = rec.getShortAt(8);
        this.m_box = new Rectangle(xBound, yBound, x1Bound - xBound, y1Bound - yBound);
        this.m_start = new Point(xStart, yStart);
        this.m_end = new Point(xEnd, yEnd);
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_box = emr.getRectangleLAt(0);
        this.m_start = emr.getPointLAt(16);
        this.m_end = emr.getPointLAt(24);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        Point2D point;
        Arc2D.Double arc;
        GdiPen curPen;
        GdiBrush brush;
        Shape shape = this.getShape(context);
        if ((this.m_type == 3 || this.m_type == 4) && (brush = context.getCurBrush()) != null) {
            brush.fill(shape, g, context);
        }
        if ((curPen = context.getCurPen()) != null) {
            curPen.apply(g, context);
            if (this.m_type == 2) {
                arc = (Arc2D.Double)shape;
                point = arc.getStartPoint();
                g.drawLine(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()), (int)point.getX(), (int)point.getY());
            }
            g.draw(shape);
        }
        if (this.m_type == 2) {
            arc = (Arc2D.Double)shape;
            point = arc.getEndPoint();
            context.setCurPosX(context.convertXToWindowsLogicalUnits((int)point.getX()));
            context.setCurPosY(context.convertYToWindowsLogicalUnits((int)point.getY()));
        }
    }

    @Override
    public void render(DeviceContext context) throws TranscoderException {
        Shape shape = this.getShape(context);
        if (this.m_type == 2) {
            GeneralPath p = context.getGdiPath().getCurrentFigure();
            p.append(shape, true);
            Arc2D.Double arc = (Arc2D.Double)shape;
            Point2D point = arc.getEndPoint();
            context.setCurPosX(context.convertXToWindowsLogicalUnits((int)point.getX()));
            context.setCurPosY(context.convertYToWindowsLogicalUnits((int)point.getY()));
        } else {
            context.getGdiPath().appendFigure(shape);
        }
    }

    private int getAngle(int triWidth, int triHeight) {
        double tan = 0.0;
        if (triWidth != 0) {
            tan = (double)triHeight / (double)triWidth;
        }
        int angle = (int)Math.toDegrees(Math.atan(tan));
        if (triWidth < 0) {
            angle += 180;
        } else if (triHeight < 0) {
            angle += 360;
        }
        return angle;
    }

    private Shape getShape(DeviceContext context) {
        int x = context.convertXToSVGLogicalUnits(this.m_box.x);
        int y = context.convertYToSVGLogicalUnits(this.m_box.y);
        int w = context.scaleX(this.m_box.width);
        int h = context.scaleY(this.m_box.height);
        int centerArcX = x + w / 2;
        int centerArcY = y + h / 2;
        int startPointX = context.convertXToSVGLogicalUnits(this.m_start.x);
        int startPointY = context.convertYToSVGLogicalUnits(this.m_start.y);
        int triWidth = startPointX - centerArcX;
        int triHeight = centerArcY - startPointY;
        int startAngle = this.getAngle(triWidth, triHeight);
        int endPointX = context.convertXToSVGLogicalUnits(this.m_end.x);
        int endPointY = context.convertYToSVGLogicalUnits(this.m_end.y);
        triWidth = endPointX - centerArcX;
        triHeight = centerArcY - endPointY;
        int endAngle = this.getAngle(triWidth, triHeight);
        int arcAngle = context.getArcDirection() == 1 ? endAngle - startAngle : startAngle - endAngle;
        int arcType = this.m_type == 1 || this.m_type == 2 ? 0 : (this.m_type == 4 ? 1 : 2);
        Rectangle bounds = new Rectangle(x, y, w, h);
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArc(bounds, startAngle, arcAngle, arcType);
        return arc;
    }
}

