/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.structure.TclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;

public class TclTypeResolver
implements ITclTypeResolver {
    private final ISourceElementRequestor fRequestor;
    private final TclModelBuildContext fContext;

    public TclTypeResolver(ISourceElementRequestor fRequestor, TclModelBuildContext fContext) {
        this.fRequestor = fRequestor;
        this.fContext = fContext;
    }

    private static String removeLastSegment(String s) {
        if (s.indexOf("::") == -1) {
            return "";
        }
        int pos = s.length() - 1;
        while (s.charAt(pos) != ':') {
            --pos;
        }
        if (pos > 1) {
            return s.substring(0, pos - 1);
        }
        return "::";
    }

    @Override
    public ITclTypeHandler resolveMemberType(IElementRequestor.ElementInfo decl, int sourceEnd, String name) {
        String type = TclTypeResolver.removeLastSegment(name);
        while (type.length() > 2 && type.endsWith("::")) {
            type = type.substring(0, type.length() - 2);
        }
        if (type.length() == 0) {
            return new ExitFromType(0, 0, false, null);
        }
        return this.resolveTypeImpl(decl, sourceEnd, type);
    }

    @Override
    public ITclTypeHandler resolveType(IElementRequestor.TypeInfo decl, int sourceEnd, String type) {
        return this.resolveTypeImpl((IElementRequestor.ElementInfo)decl, sourceEnd, type);
    }

    private ITclTypeHandler resolveTypeImpl(IElementRequestor.ElementInfo decl, int sourceEnd, String type) {
        if (type.equals("::")) {
            this.fRequestor.enterModuleRoot();
            return new ExitFromType(0, sourceEnd, true, "::");
        }
        boolean fqn = type.startsWith("::");
        String fullyQualified = type;
        if (!fqn) {
            String e = this.fContext.getEnclosingNamespace();
            if (e == null) {
                throw new AssertionError((Object)"there are no enclosing namespace!");
            }
            if (!e.endsWith("::")) {
                e = String.valueOf(e) + "::";
            }
            fullyQualified = String.valueOf(e) + type;
        }
        if (this.fRequestor.enterTypeAppend(type, "::")) {
            return new ExitFromType(1, sourceEnd, false, fullyQualified);
        }
        int needEnterLeave = 0;
        String[] split = null;
        String e = this.fContext.getEnclosingNamespace();
        if (e == null) {
            throw new AssertionError((Object)"there are no enclosing namespace!");
        }
        boolean entered = false;
        boolean exitFromModule = false;
        if (e.length() > 0 && !fqn) {
            entered = this.fRequestor.enterTypeAppend(e, "::");
        }
        if (fqn || !entered) {
            split = TclParseUtil.tclSplit(fullyQualified.substring(2));
            this.fRequestor.enterModuleRoot();
            exitFromModule = true;
        } else {
            if (!entered) {
                throw new AssertionError((Object)"can't enter to enclosing namespace!");
            }
            ++needEnterLeave;
            split = TclParseUtil.tclSplit(type);
        }
        int i = 0;
        while (i < split.length) {
            if (split[i].length() > 0) {
                ++needEnterLeave;
                if (!this.fRequestor.enterTypeAppend(split[i], "::")) {
                    IElementRequestor.TypeInfo ti = new IElementRequestor.TypeInfo();
                    ti.modifiers = decl instanceof IElementRequestor.TypeInfo ? ((IElementRequestor.TypeInfo)decl).modifiers : 2048;
                    ti.name = split[i];
                    ti.nameSourceStart = decl.nameSourceStart;
                    ti.nameSourceEnd = decl.nameSourceEnd;
                    ti.declarationStart = decl.declarationStart;
                    if (decl instanceof IElementRequestor.TypeInfo) {
                        ti.superclasses = ((IElementRequestor.TypeInfo)decl).superclasses;
                    }
                    this.fRequestor.enterType(ti);
                }
            }
            ++i;
        }
        return new ExitFromType(needEnterLeave, sourceEnd, exitFromModule, fullyQualified, true);
    }

    private static class ExitFromType
    implements ITclModelBuildContext.ITclModelHandler,
    ITclTypeHandler {
        private int level;
        private int end;
        private boolean exitFromModule;
        private String namespace;

        public ExitFromType(int level, int declEnd, boolean mod, String pop) {
            this(level, declEnd, mod, pop, false);
        }

        public ExitFromType(int level, int declEnd, boolean mod, String pop, boolean created) {
            this.level = level;
            this.end = declEnd;
            this.exitFromModule = mod;
            this.namespace = pop;
        }

        @Override
        public void leave(ISourceElementRequestor requestor) {
            int i = 0;
            while (i < this.level) {
                requestor.exitType(this.end);
                ++i;
            }
            if (this.exitFromModule) {
                requestor.exitModuleRoot();
            }
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }
    }
}

