package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Immutable implementation of {@link NetworkingConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNetworkingConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableNetworkingConfig implements NetworkingConfig {
  private final Map<String, EndpointConfig> endpointsConfig;

  private ImmutableNetworkingConfig(Map<String, EndpointConfig> endpointsConfig) {
    this.endpointsConfig = endpointsConfig;
  }

  /**
   * @return The value of the {@code endpointsConfig} attribute
   */
  @JsonProperty("EndpointsConfig")
  @Override
  public Map<String, EndpointConfig> endpointsConfig() {
    return endpointsConfig;
  }

  /**
   * Copy the current immutable object by replacing the {@link NetworkingConfig#endpointsConfig() endpointsConfig} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the endpointsConfig map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableNetworkingConfig withEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
    if (this.endpointsConfig == entries) return this;
    Map<String, EndpointConfig> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableNetworkingConfig(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNetworkingConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNetworkingConfig
        && equalsByValue((ImmutableNetworkingConfig) another);
  }

  private boolean equalsByValue(ImmutableNetworkingConfig another) {
    return endpointsConfig.equals(another.endpointsConfig);
  }

  /**
   * Computes a hash code from attributes: {@code endpointsConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + endpointsConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NetworkingConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NetworkingConfig{"
        + "endpointsConfig=" + endpointsConfig
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NetworkingConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NetworkingConfig instance
   */
  public static ImmutableNetworkingConfig copyOf(NetworkingConfig instance) {
    if (instance instanceof ImmutableNetworkingConfig) {
      return (ImmutableNetworkingConfig) instance;
    }
    return ImmutableNetworkingConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNetworkingConfig ImmutableNetworkingConfig}.
   * <pre>
   * ImmutableNetworkingConfig.builder()
   *    .addEndpointsConfig|putAllEndpointsConfig(String =&gt; org.mandas.docker.client.messages.EndpointConfig) // {@link NetworkingConfig#endpointsConfig() endpointsConfig} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableNetworkingConfig builder
   */
  public static ImmutableNetworkingConfig.Builder builder() {
    return new ImmutableNetworkingConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNetworkingConfig ImmutableNetworkingConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements NetworkingConfig.Builder {
    private Map<String, EndpointConfig> endpointsConfig = new LinkedHashMap<String, EndpointConfig>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NetworkingConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NetworkingConfig instance) {
      Objects.requireNonNull(instance, "instance");
      putAllEndpointsConfig(instance.endpointsConfig());
      return this;
    }

    /**
     * Put one entry to the {@link NetworkingConfig#endpointsConfig() endpointsConfig} map.
     * @param key The key in the endpointsConfig map
     * @param value The associated value in the endpointsConfig map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEndpointsConfig(String key, EndpointConfig value) {
      this.endpointsConfig.put(
          Objects.requireNonNull(key, "endpointsConfig key"),
          Objects.requireNonNull(value, value == null ? "endpointsConfig value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link NetworkingConfig#endpointsConfig() endpointsConfig} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEndpointsConfig(Map.Entry<String, ? extends EndpointConfig> entry) {
      String k = entry.getKey();
      EndpointConfig v = entry.getValue();
      this.endpointsConfig.put(
          Objects.requireNonNull(k, "endpointsConfig key"),
          Objects.requireNonNull(v, v == null ? "endpointsConfig value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NetworkingConfig#endpointsConfig() endpointsConfig} map. Nulls are not permitted
     * @param entries The entries that will be added to the endpointsConfig map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("EndpointsConfig")
    public final Builder endpointsConfig(Map<String, ? extends EndpointConfig> entries) {
      this.endpointsConfig.clear();
      return putAllEndpointsConfig(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NetworkingConfig#endpointsConfig() endpointsConfig} map. Nulls are not permitted
     * @param entries The entries that will be added to the endpointsConfig map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEndpointsConfig(Map<String, ? extends EndpointConfig> entries) {
      for (Map.Entry<String, ? extends EndpointConfig> e : entries.entrySet()) {
        String k = e.getKey();
        EndpointConfig v = e.getValue();
        this.endpointsConfig.put(
            Objects.requireNonNull(k, "endpointsConfig key"),
            Objects.requireNonNull(v, v == null ? "endpointsConfig value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableNetworkingConfig ImmutableNetworkingConfig}.
     * @return An immutable instance of NetworkingConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNetworkingConfig build() {
      return new ImmutableNetworkingConfig(createUnmodifiableMap(false, false, endpointsConfig));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
