/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;

public class ServerPatternFilter
extends PatternFilter {
    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText;
        boolean b = super.isLeafMatch(viewer, element);
        if (b) {
            return true;
        }
        Object parent = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getParent(element);
        if (parent != null && (labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(parent)) != null && this.wordMatches(labelText)) {
            return true;
        }
        if (element instanceof IRuntimeType && this.matchesRuntimeType((IRuntimeType)element)) {
            return true;
        }
        if (element instanceof IRuntime && this.matchesRuntime((IRuntime)element)) {
            return true;
        }
        if (element instanceof IServerType && this.matchesServerType((IServerType)element)) {
            return true;
        }
        return element instanceof IServer && this.matchesServer((IServer)element);
    }

    protected boolean matchesModuleType(IModuleType mt) {
        String text = mt.getName();
        if (this.wordMatches(text)) {
            return true;
        }
        text = mt.getVersion();
        return this.wordMatches(text);
    }

    protected boolean matchesRuntimeType(IRuntimeType rt) {
        String text = rt.getName();
        if (this.wordMatches(text)) {
            return true;
        }
        text = rt.getDescription();
        if (this.wordMatches(text)) {
            return true;
        }
        text = rt.getVendor();
        if (this.wordMatches(text)) {
            return true;
        }
        text = rt.getVersion();
        if (this.wordMatches(text)) {
            return true;
        }
        IModuleType[] mts = rt.getModuleTypes();
        if (mts != null) {
            int size = mts.length;
            int i = 0;
            while (i < size) {
                if (this.matchesModuleType(mts[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean matchesRuntime(IRuntime r) {
        String text = r.getName();
        if (this.wordMatches(text)) {
            return true;
        }
        if (r.getLocation() != null) {
            text = r.getLocation().toPortableString();
            if (this.wordMatches(text)) {
                return true;
            }
            text = r.getLocation().toOSString();
            if (this.wordMatches(text)) {
                return true;
            }
        }
        return r.getRuntimeType() != null && this.matchesRuntimeType(r.getRuntimeType());
    }

    protected boolean matchesServerType(IServerType st) {
        String text = st.getDescription();
        if (this.wordMatches(text)) {
            return true;
        }
        return st.getRuntimeType() != null && this.matchesRuntimeType(st.getRuntimeType());
    }

    protected boolean matchesServer(IServer st) {
        String text = st.getName();
        if (this.wordMatches(text)) {
            return true;
        }
        return st.getServerType() != null && this.matchesServerType(st.getServerType());
    }
}

