/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.api.pages;

import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;
import org.eclipse.sirius.ui.editor.internal.pages.RemovePageCommand;
import org.eclipse.sirius.ui.editor.internal.pages.RenameTabLabelCommand;
import org.eclipse.sirius.ui.editor.internal.pages.ReorderPageCommand;

public class PageUpdateCommandBuilder {
    PageUpdateCommand pageUpdateCommand = new PageUpdateCommand();

    public PageUpdateCommandBuilder renameTab(String newLabel) {
        this.pageUpdateCommand.setRenameCommand(new RenameTabLabelCommand(newLabel));
        return this;
    }

    public PageUpdateCommandBuilder removePage() {
        this.pageUpdateCommand.setRemoveCommand(new RemovePageCommand());
        return this;
    }

    public PageUpdateCommandBuilder reorderPage(PageProviderRegistry.PositioningKind positioningKind, String targetPageId) {
        this.pageUpdateCommand.setReorderCommand(new ReorderPageCommand(positioningKind, targetPageId));
        return this;
    }

    public PageUpdateCommand build() {
        return this.pageUpdateCommand;
    }

    public final class PageUpdateCommand {
        RemovePageCommand removeCommand;
        RenameTabLabelCommand renameCommand;
        ReorderPageCommand reorderCommand;

        private PageUpdateCommand() {
        }

        public RemovePageCommand getRemoveCommand() {
            return this.removeCommand;
        }

        public RenameTabLabelCommand getRenameCommand() {
            return this.renameCommand;
        }

        public ReorderPageCommand getReorderCommand() {
            return this.reorderCommand;
        }

        public void setRenameCommand(RenameTabLabelCommand renameCommand) {
            this.renameCommand = renameCommand;
        }

        public void setRemoveCommand(RemovePageCommand removePageCommand) {
            this.removeCommand = removePageCommand;
        }

        public void setReorderCommand(ReorderPageCommand reorderCommand) {
            this.reorderCommand = reorderCommand;
        }
    }
}

