/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.processes.ui.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.ui.dialogs.SystemDeleteTableRow;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;

public class SystemKillTableRow
extends SystemDeleteTableRow {
    private Object element;
    private String exename;
    private String pid;
    private ImageDescriptor imageDescriptor;
    private ISystemViewElementAdapter adapter;
    private ISystemRemoteElementAdapter remoteAdapter;
    private int rowNbr = 0;

    public SystemKillTableRow(Object element, int rowNbr) {
        super(element, rowNbr);
        if (element instanceof SystemSimpleContentElement) {
            element = ((SystemSimpleContentElement)element).getData();
        }
        this.element = element;
        this.adapter = this.getViewAdapter(element);
        this.remoteAdapter = this.getRemoteAdapter(element);
        this.rowNbr = rowNbr;
        if (this.adapter != null) {
            this.exename = this.adapter.getName(element);
        } else if (element instanceof IRemoteProcess) {
            this.exename = ((IRemoteProcess)element).getName();
        }
        if (element instanceof IRemoteProcess) {
            this.pid = "" + ((IRemoteProcess)element).getPid();
        }
        this.imageDescriptor = this.adapter != null ? this.adapter.getImageDescriptor(element) : RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.full/obj16/systemprocess.gifIcon");
    }

    public String getName() {
        return this.exename;
    }

    public String getType() {
        return this.pid;
    }

    public int getRowNumber() {
        return this.rowNbr;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public Object getElement() {
        return this.element;
    }

    public ISystemViewElementAdapter getViewAdapter() {
        return this.adapter;
    }

    public ISystemRemoteElementAdapter getRemoteAdapter() {
        return this.remoteAdapter;
    }

    public boolean isRemote() {
        return this.remoteAdapter != null;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter((Object)o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public String toString() {
        return this.exename;
    }
}

