/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.action;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.action.Messages;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.BugzillaTaskEditorPage;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.FlagAttributeEditor;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.BugzillaAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.services.IServiceLocator;

public class BugzillaAttachmentUpdateAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private ISelection currentSelection;

    public BugzillaAttachmentUpdateAction() {
        super("BugzillaAttachmentDetailAction");
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        TaskEditor taskEditor;
        IFormPage taskEditorPage;
        IStructuredSelection selection = null;
        if (this.currentSelection instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.currentSelection;
        }
        if (selection == null || selection.isEmpty() || selection.size() != 1) {
            return;
        }
        ITaskAttachment attachment = (ITaskAttachment)selection.getFirstElement();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        IWorkbenchPartSite site = activeEditor.getSite();
        Shell shell = site.getShell();
        if (activeEditor instanceof TaskEditor && (taskEditorPage = (taskEditor = (TaskEditor)activeEditor).findPage("id")) instanceof BugzillaTaskEditorPage) {
            BugzillaTaskEditorPage bugzillaTaskEditorPage = (BugzillaTaskEditorPage)taskEditorPage;
            ITask attachmentTask = attachment.getTask();
            TaskTask nTask = new TaskTask(attachmentTask.getConnectorKind(), attachmentTask.getRepositoryUrl(), attachmentTask.getTaskId() + "attachment");
            TaskData editTaskData = new TaskData(attachment.getTaskAttribute().getTaskData().getAttributeMapper(), attachment.getTaskAttribute().getTaskData().getConnectorKind(), attachment.getTaskAttribute().getTaskData().getRepositoryUrl(), attachment.getTaskAttribute().getTaskData().getTaskId());
            editTaskData.setVersion(attachment.getTaskAttribute().getTaskData().getVersion());
            TaskAttribute target0 = editTaskData.getRoot();
            TaskAttribute temp = attachment.getTaskAttribute();
            target0.setValues(temp.getValues());
            for (TaskAttribute child : temp.getAttributes().values()) {
                target0.deepAddCopy(child);
            }
            TaskAttribute comment = target0.createAttribute("comment");
            TaskAttributeMetaData commentMeta = comment.getMetaData();
            commentMeta.setType("longRichText");
            commentMeta.setLabel(Messages.BugzillaAttachmentUpdateAction_Comment);
            ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy((ITask)nTask, editTaskData);
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(attachment.getTaskAttribute().getTaskData().getRepositoryUrl());
            final String repositoryLabel = repository.getRepositoryLabel();
            final TaskDataModel model = new TaskDataModel(repository, (ITask)nTask, workingCopy);
            AttributeEditorFactory factory = new AttributeEditorFactory(model, repository, (IServiceLocator)bugzillaTaskEditorPage.getEditorSite()){

                public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                    AbstractAttributeEditor editor;
                    if ("bugzilla.editor.flag".equals(type)) {
                        editor = new FlagAttributeEditor(model, taskAttribute);
                    } else {
                        editor = super.createEditor(type, taskAttribute);
                        if ("boolean".equals(type)) {
                            editor.setDecorationEnabled(false);
                        }
                    }
                    return editor;
                }
            };
            TaskAttribute target = workingCopy.getLocalData().getRoot();
            target.setValue(target0.getValue());
            final BugzillaAttachmentWizard attachmentWizard = new BugzillaAttachmentWizard(shell, factory, target, taskEditor, attachment, repository.getRepositoryLabel());
            final NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(shell, (IWizard)attachmentWizard, false){

                protected IDialogSettings getDialogBoundsSettings() {
                    IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
                    IDialogSettings section = settings.getSection("BugzillaAttachmentWizard." + repositoryLabel);
                    if (section == null) {
                        section = settings.addNewSection("BugzillaAttachmentWizard." + repositoryLabel);
                    }
                    return section;
                }
            };
            model.addModelListener(new TaskDataModelListener(){

                public void attributeChanged(TaskDataModelEvent event) {
                    attachmentWizard.setChanged(true);
                    dialog.updateButtons();
                }
            });
            dialog.setBlockOnOpen(false);
            dialog.create();
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        IStructuredSelection sructuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            sructuredSelection = (IStructuredSelection)this.currentSelection;
        }
        if (sructuredSelection == null || sructuredSelection.isEmpty()) {
            return;
        }
        List attachmentList = sructuredSelection.toList();
        if (attachmentList != null && attachmentList.size() == 1) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

