/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.TapsetParser;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public abstract class TreeTapsetParser
extends TapsetParser {
    private final Object lock = new Object();
    protected TreeNode tree = new TreeNode(null, false);
    private TreeNode forcedTree = null;
    private TapsetChanges tapsetChanges = null;

    protected TreeTapsetParser(String jobTitle) {
        super(jobTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus safelyAddJobChangeListener(IJobChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            super.addJobChangeListener(listener);
            return this.getLatestResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus getLatestResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.getState() != 4 ? this.getResult() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized IStatus run(IProgressMonitor monitor) {
        IStatus result;
        if (this.forcedTree != null) {
            if (this.isValidTree(this.forcedTree)) {
                this.tree = this.forcedTree;
                result = this.createStatus(0);
            } else {
                result = this.createStatus(4, Messages.TapsetParser_ErrorInvalidTapsetTree);
            }
            this.forcedTree = null;
        } else if (this.tapsetChanges != null) {
            result = this.performUpdate(monitor);
        } else {
            this.tree = new TreeNode(null, false);
            result = this.createStatus(this.runAction(monitor));
        }
        Object object = this.lock;
        synchronized (object) {
            return result;
        }
    }

    protected abstract int runAction(IProgressMonitor var1);

    public synchronized void runUpdate(String[] additions, String[] deletions) {
        this.tapsetChanges = new TapsetChanges(this, additions, deletions);
        this.schedule();
    }

    private IStatus performUpdate(IProgressMonitor monitor) {
        int result = 0;
        if (this.tapsetChanges.deletions.length > 0) {
            result = this.delTapsets(this.tapsetChanges.deletions, monitor);
        }
        if (result == 0 && this.tapsetChanges.additions.length > 0) {
            if (monitor.isCanceled()) {
                result = 8;
            } else {
                String tapsetContents = SharedParser.getInstance().getTapsetContents();
                result = this.verifyRunResult(tapsetContents);
                if (result == 0) {
                    result = this.addTapsets(tapsetContents, this.tapsetChanges.additions, monitor);
                }
            }
        }
        this.tapsetChanges = null;
        return this.createStatus(result);
    }

    protected abstract int delTapsets(String[] var1, IProgressMonitor var2);

    protected abstract int addTapsets(String var1, String[] var2, IProgressMonitor var3);

    public final TreeNode getTree() {
        return this.tree;
    }

    public final void setTree(TreeNode tree) {
        this.cancel();
        this.forcedTree = tree;
        this.schedule();
    }

    protected boolean isValidTree(TreeNode tree) {
        return tree != null;
    }

    private class TapsetChanges {
        private String[] additions;
        private String[] deletions;

        private TapsetChanges(TreeTapsetParser treeTapsetParser, String[] additions, String[] deletions) {
            this.additions = new String[additions.length];
            this.deletions = new String[deletions.length];
            System.arraycopy(additions, 0, this.additions, 0, additions.length);
            System.arraycopy(deletions, 0, this.deletions, 0, deletions.length);
        }
    }
}

