/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.jface.AbstractModelItemLabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

public class ModelItemExtendedLabelProvider
extends AbstractModelItemLabelProvider<ItemExtendedLabelProvider.Manager>
implements ItemExtendedLabelProvider {
    private final PropertyValueModel<String> descriptionModel;
    private final PropertyChangeListener descriptionListener;
    private String description;

    public ModelItemExtendedLabelProvider(Object item, ItemExtendedLabelProvider.Manager manager, PropertyValueModel<ImageDescriptor> imageDescriptorModel, PropertyValueModel<String> textModel, PropertyValueModel<String> descriptionModel) {
        super(item, manager, imageDescriptorModel, textModel);
        if (descriptionModel == null) {
            throw new NullPointerException();
        }
        this.descriptionModel = descriptionModel;
        this.descriptionListener = this.buildDescriptionListener();
        this.descriptionModel.addPropertyChangeListener("value", this.descriptionListener);
        this.description = (String)this.descriptionModel.getValue();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private PropertyChangeListener buildDescriptionListener() {
        return SWTListenerTools.wrap(this.buildDescriptionListener_(), (Viewer)((ItemExtendedLabelProvider.Manager)this.manager).getViewer());
    }

    private PropertyChangeListener buildDescriptionListener_() {
        return new DescriptionListener();
    }

    void descriptionChanged(String newValue) {
        if (this.isAlive()) {
            this.descriptionChanged_(newValue);
        }
    }

    private void descriptionChanged_(String newValue) {
        this.description = newValue;
        ((ItemExtendedLabelProvider.Manager)this.manager).descriptionChanged(this.item);
    }

    @Override
    public void dispose() {
        this.descriptionModel.removePropertyChangeListener("value", this.descriptionListener);
        this.description = null;
        super.dispose();
    }

    class DescriptionListener
    extends PropertyChangeAdapter {
        DescriptionListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            ModelItemExtendedLabelProvider.this.descriptionChanged((String)event.getNewValue());
        }
    }
}

