/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.BookmarkManager;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.Topic;

public class BookmarksData
extends RequestData {
    public static final int NONE = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int REMOVE_ALL = 3;

    public BookmarksData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        switch (this.getOperation()) {
            case 1: {
                this.addBookmark();
                break;
            }
            case 2: {
                this.removeBookmark();
                break;
            }
            case 3: {
                this.removeAllBookmarks();
                break;
            }
        }
    }

    public void addBookmark() {
        String bookmarkURL = this.request.getParameter("bookmark");
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            String title = this.request.getParameter("title");
            if (title == null) {
                return;
            }
            BookmarkManager manager = BaseHelpSystem.getBookmarkManager();
            manager.addBookmark(bookmarkURL, title);
        }
    }

    public void removeBookmark() {
        String bookmarkURL = this.request.getParameter("bookmark");
        if (bookmarkURL != null && bookmarkURL.length() > 0 && !bookmarkURL.equals("about:blank")) {
            String title = this.request.getParameter("title");
            if (title == null) {
                return;
            }
            BookmarkManager manager = BaseHelpSystem.getBookmarkManager();
            manager.removeBookmark(bookmarkURL, title);
        }
    }

    public void removeAllBookmarks() {
        BookmarkManager manager = BaseHelpSystem.getBookmarkManager();
        manager.removeAllBookmarks();
    }

    public Topic[] getBookmarks() {
        if (BaseHelpSystem.getMode() != 1) {
            BookmarkManager manager = BaseHelpSystem.getBookmarkManager();
            IHelpResource[] bookmarks = manager.getBookmarks();
            Topic[] topics = new Topic[bookmarks.length];
            int i = 0;
            while (i < bookmarks.length) {
                IHelpResource bookmark = bookmarks[i];
                topics[i] = new Topic(bookmark.getLabel(), bookmark.getHref());
                ++i;
            }
            return topics;
        }
        return new Topic[0];
    }

    private int getOperation() {
        String op = this.request.getParameter("operation");
        if ("add".equals(op)) {
            return 1;
        }
        if ("remove".equals(op)) {
            return 2;
        }
        if ("removeAll".equals(op)) {
            return 3;
        }
        return 0;
    }
}

