/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public abstract class CDOServerLockStatePrefetcher {
    private CDOServerLockStatePrefetcher() {
    }

    public abstract void addLockStateKey(CDOID var1);

    public abstract void addLockStateKey(Supplier<CDOID> var1);

    public abstract void writeLockStates(CDODataOutput var1) throws IOException;

    public static CDOServerLockStatePrefetcher create(InternalRepository repository, CDOBranchPoint branchPoint, boolean prefetchLockStates) {
        if (!prefetchLockStates) {
            return new None();
        }
        if (branchPoint == null || branchPoint.getTimeStamp() != 0L) {
            return new None();
        }
        CDOBranch branch = branchPoint.getBranch();
        if (repository.isSupportingBranches()) {
            return new Branching(repository, branch);
        }
        return new Normal(repository, branch, null, null);
    }

    /* synthetic */ CDOServerLockStatePrefetcher(CDOServerLockStatePrefetcher cDOServerLockStatePrefetcher) {
        this();
    }

    private static class Branching
    extends Normal {
        private Branching(InternalRepository repository, CDOBranch branch) {
            super(repository, branch);
        }

        @Override
        protected void writeNoLockStateKeys(CDODataOutput out, Set<Object> noLockStateKeys) throws IOException {
            for (Object key : noLockStateKeys) {
                out.writeCDOID(((CDOIDAndBranch)key).getID());
            }
        }
    }

    private static final class None
    extends CDOServerLockStatePrefetcher {
        private None() {
            super(null);
        }

        @Override
        public void addLockStateKey(CDOID id) {
        }

        @Override
        public void addLockStateKey(Supplier<CDOID> idSupplier) {
        }

        @Override
        public void writeLockStates(CDODataOutput out) throws IOException {
            out.writeBoolean(false);
        }
    }

    private static class Normal
    extends CDOServerLockStatePrefetcher {
        private final Set<Object> lockStateKeys = new HashSet<Object>();
        private final InternalLockManager lockingManager;
        private final CDOBranch branch;

        private Normal(InternalRepository repository, CDOBranch branch) {
            super(null);
            this.lockingManager = repository.getLockingManager();
            this.branch = branch;
        }

        @Override
        public void addLockStateKey(CDOID id) {
            Object key = this.lockingManager.getLockKey(id, this.branch);
            this.lockStateKeys.add(key);
        }

        @Override
        public void addLockStateKey(Supplier<CDOID> idSupplier) {
            CDOID id;
            if (idSupplier != null && (id = idSupplier.get()) != null) {
                this.addLockStateKey(id);
            }
        }

        @Override
        public void writeLockStates(CDODataOutput out) throws IOException {
            out.writeBoolean(true);
            HashSet<Object> noLockStateKeys = new HashSet<Object>();
            try {
                this.lockingManager.getLockStates(this.lockStateKeys, (key, lockState) -> {
                    if (lockState != null) {
                        CDOLockState cdoLockState = CDOLockUtil.convertLockState((RWOLockManager.LockState)lockState);
                        try {
                            out.writeCDOLockState(cdoLockState);
                        }
                        catch (IOException ex) {
                            throw WrappedException.wrap((Exception)ex);
                        }
                    } else {
                        noLockStateKeys.add(key);
                    }
                });
            }
            catch (WrappedException ex) {
                Exception exception = ex.exception();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw ex;
            }
            out.writeCDOLockState(null);
            out.writeXInt(noLockStateKeys.size());
            this.writeNoLockStateKeys(out, noLockStateKeys);
        }

        protected void writeNoLockStateKeys(CDODataOutput out, Set<Object> noLockStateKeys) throws IOException {
            for (Object key : noLockStateKeys) {
                out.writeCDOID((CDOID)key);
            }
        }

        /* synthetic */ Normal(InternalRepository internalRepository, CDOBranch cDOBranch, Normal normal, Normal normal2) {
            this(internalRepository, cDOBranch);
        }
    }
}

