/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.compiler.task.TaskTagUtils;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.internal.ui.coloring.ColoringConfigurationModelCollector;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingManager;
import org.eclipse.dltk.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.PreferencesAdapter;
import org.eclipse.dltk.ui.coloring.ColoringPreferences;
import org.eclipse.dltk.ui.coloring.IColoringCategoryConstants;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceProvider;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractScriptEditorColoringConfigurationBlock
extends AbstractConfigurationBlock
implements IColoringCategoryConstants {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    protected final List<HighlightingColorListItem> fListModel = new ArrayList<HighlightingColorListItem>();
    private StructuredViewer fListViewer;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private ProjectionViewer fPreviewViewer;
    private IColorManager fColorManager = new DLTKColorManager(false);

    protected String[] getCategories() {
        return new String[]{sCoreCategory, sDocumentationCategory, sCommentsCategory};
    }

    protected String[][] getSyntaxColorListModel() {
        ColoringConfigurationModelCollector collector = new ColoringConfigurationModelCollector();
        String natureId = this.getNatureId();
        Assert.isNotNull((Object)natureId);
        IColoringPreferenceProvider[] providers = ColoringPreferences.getProviders(natureId);
        if (providers != null) {
            IColoringPreferenceProvider[] iColoringPreferenceProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IColoringPreferenceProvider provider = iColoringPreferenceProviderArray[n2];
                provider.providePreferences(collector);
                ++n2;
            }
        }
        return collector.getColorListModel();
    }

    protected String getNatureId() {
        return null;
    }

    protected abstract ProjectionViewer createPreviewViewer(Composite var1, IVerticalRuler var2, IOverviewRuler var3, boolean var4, int var5, IPreferenceStore var6);

    protected abstract ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager var1, IPreferenceStore var2, ITextEditor var3, boolean var4);

    protected abstract void setDocumentPartitioning(IDocument var1);

    protected Object[] getElementsForCategory(String entry) {
        ArrayList<HighlightingColorListItem> elements = new ArrayList<HighlightingColorListItem>();
        for (HighlightingColorListItem item : this.fListModel) {
            if (!entry.equals(item.getCategory())) continue;
            elements.add(item);
        }
        return elements.toArray();
    }

    public AbstractScriptEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        HashSet<String> colorKeys = new HashSet<String>();
        String[][] model = this.getSyntaxColorListModel();
        int i = 0;
        int n = model.length;
        while (i < n) {
            String colorKey = model[i][1];
            if (colorKeys.add(colorKey)) {
                if (model[i].length == 3) {
                    this.fListModel.add(new HighlightingColorListItem(model[i][0], colorKey, colorKey + BOLD, colorKey + ITALIC, colorKey + STRIKETHROUGH, colorKey + UNDERLINE, model[i][2]));
                } else {
                    this.fListModel.add(new SemanticHighlightingColorListItem(model[i][0], colorKey, colorKey + BOLD, colorKey + ITALIC, colorKey + STRIKETHROUGH, colorKey + UNDERLINE, model[i][2], colorKey + "_enabled"));
                }
            }
            ++i;
        }
        SemanticHighlighting[] highlightings = this.getSemanticHighlightings();
        int i2 = 0;
        while (i2 < highlightings.length) {
            SemanticHighlighting h = highlightings[i2];
            if (h.isSemanticOnly()) {
                String colorKey = h.getPreferenceKey();
                if (colorKeys.add(colorKey)) {
                    this.fListModel.add(new SemanticHighlightingColorListItem(h.getDisplayName(), colorKey, colorKey + BOLD, colorKey + ITALIC, colorKey + STRIKETHROUGH, colorKey + UNDERLINE, sCoreCategory, h.getEnabledPreferenceKey()));
                }
            } else if (!colorKeys.contains(h.getPreferenceKey())) {
                String msgText = PreferencesMessages.DLTKEditorPreferencePage_coloring_semantic_not_configurable;
                DLTKUIPlugin.warn(NLS.bind((String)msgText, (Object)h.getPreferenceKey()));
            }
            ++i2;
        }
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        int n = this.fListModel.size();
        while (i < n) {
            HighlightingColorListItem item = this.fListModel.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item instanceof SemanticHighlightingColorListItem) {
                SemanticHighlightingColorListItem shItem = (SemanticHighlightingColorListItem)item;
                String enableKey = shItem.getEnableKey();
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, enableKey));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        return this.createSyntaxPage(parent);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.fListViewer.setInput(this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)sCoreCategory));
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.uninstallSemanticHighlighting();
        this.installSemanticHighlighting();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    @Override
    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        Link link = new Link(colorComposite, 0);
        link.setText(PreferencesMessages.DLTKEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(colorComposite, 1);
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.DLTKEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fListViewer = new TreeViewer(editorComposite, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider(this.getColorListContentProvider());
        this.fListViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (sCoreCategory.equals(element)) {
                    return 0;
                }
                if (sDocumentationCategory.equals(element)) {
                    return 1;
                }
                if (sCommentsCategory.equals(element)) {
                    return 2;
                }
                if (element instanceof String) {
                    return 3;
                }
                return 0;
            }
        });
        gd = new GridData(1, 1, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        for (HighlightingColorListItem item : this.fListModel) {
            maxWidth = Math.max(maxWidth, this.convertWidthInCharsToPixels(item.getDisplayName().length()));
        }
        ScrollBar vBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 3;
        }
        gd.widthHint = maxWidth;
        this.fListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.DLTKEditorPreferencePage_enable);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.DLTKEditorPreferencePage_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.DLTKEditorPreferencePage_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.DLTKEditorPreferencePage_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.DLTKEditorPreferencePage_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.DLTKEditorPreferencePage_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.DLTKEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        if (previewer != null) {
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(20);
            gd.heightHint = this.convertHeightInCharsToPixels(5);
            previewer.setLayoutData((Object)gd);
        } else {
            label.dispose();
        }
        this.fListViewer.addSelectionChangedListener(event -> this.handleSyntaxColorListSelection());
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)AbstractScriptEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), AbstractScriptEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), AbstractScriptEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), AbstractScriptEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), AbstractScriptEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AbstractScriptEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = AbstractScriptEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    AbstractScriptEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                    AbstractScriptEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    AbstractScriptEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        colorComposite.layout(false);
        return colorComposite;
    }

    protected IContentProvider getColorListContentProvider() {
        return new ColorListContentProvider();
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = this.createPreviewViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        if (this.fPreviewViewer == null) {
            return null;
        }
        ScriptSourceViewerConfiguration configuration = this.createSimpleSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        if (this.fPreviewViewer.getTextWidget().getTabs() == 0) {
            this.fPreviewViewer.getTextWidget().setTabs(4);
        }
        new ScriptSourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.getPreviewContent();
        Document document = new Document(content);
        this.setDocumentPartitioning((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences store = new Preferences();
        TaskTagUtils.initializeDefaultValues((Preferences)store);
        return store;
    }

    protected ScriptTextTools getTextTools() {
        return null;
    }

    protected SemanticHighlighting[] getSemanticHighlightings() {
        ScriptTextTools textTools = this.getTextTools();
        return textTools != null ? textTools.getSemanticHighlightings() : new SemanticHighlighting[]{};
    }

    private void installSemanticHighlighting() {
        ISemanticHighlightingUpdater updater;
        ScriptTextTools textTools = this.getTextTools();
        if (this.fSemanticHighlightingManager == null && textTools != null && (updater = textTools.getSemanticPositionUpdater(this.getNatureId())) != null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager(updater);
            this.fSemanticHighlightingManager.install((ScriptSourceViewer)this.fPreviewViewer, this.fColorManager, this.getPreferenceStore());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = this.fListViewer.getStructuredSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)element;
    }

    protected String getPreviewContent() {
        StringBuffer buffer;
        block16: {
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(this.getPreviewContentReader()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (buffer.length() != 0) {
                            buffer.append(Util.LINE_SEPARATOR);
                        }
                        buffer.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buffer.toString();
    }

    protected InputStream getPreviewContentReader() {
        return null;
    }

    protected class ColorListContentProvider
    implements ITreeContentProvider {
        protected ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> categorys = new ArrayList<String>();
            String[] stringArray = AbstractScriptEditorColoringConfigurationBlock.this.getCategories();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (AbstractScriptEditorColoringConfigurationBlock.this.getElementsForCategory(cat).length > 0) {
                    categorys.add(cat);
                }
                ++n2;
            }
            for (HighlightingColorListItem item : AbstractScriptEditorColoringConfigurationBlock.this.fListModel) {
                if (categorys.contains(item.getCategory())) continue;
                categorys.add(item.getCategory());
            }
            return categorys.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                return AbstractScriptEditorColoringConfigurationBlock.this.getElementsForCategory(entry);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof HighlightingColorListItem) {
                return ((HighlightingColorListItem)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((HighlightingColorListItem)element).getDisplayName();
        }
    }

    protected static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;
        private final String fCategory;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String category) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
            this.fCategory = category;
        }

        public String[] getKeys() {
            return new String[]{this.fColorKey, this.fBoldKey, this.fItalicKey, this.fStrikethroughKey, this.fUnderlineKey};
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String category, String enableKey) {
            super(displayName, colorKey, boldKey, italicKey, strikethroughKey, underlineKey, category);
            Assert.isNotNull((Object)enableKey);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }

        @Override
        public String[] getKeys() {
            String[] keys = super.getKeys();
            String[] result = new String[keys.length + 1];
            System.arraycopy(keys, 0, result, 0, keys.length);
            result[keys.length] = this.fEnableKey;
            return result;
        }
    }
}

