/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.util.AccessControlUtilities;
import org.eclipse.datatools.enablement.ibm.util.ClientConfiguration;
import org.eclipse.datatools.enablement.ibm.util.ClientStrategyResolver;
import org.eclipse.datatools.enablement.ibm.util.ClientStrategyResolverException;
import org.eclipse.datatools.enablement.ibm.util.ICloningInfoProvider;
import org.eclipse.datatools.enablement.ibm.util.IPostprocessProvider;
import org.eclipse.datatools.enablement.ibm.util.PostProcessingRegistryReader;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class CloneUtil {
    private static Hashtable packages = CloneUtil.getProviders();
    private static Hashtable requiredFeatures = CloneUtil.getRequiredFeatures();
    private static ClientConfiguration client = new ClientConfiguration("CLONE_UTIL");

    public static EObject[] clone(EObject targetContainer, EObject obj) {
        return CloneUtil.cloneWithElementMap(targetContainer, obj, new HashMap());
    }

    public static EObject[] clone(EObject[] targetContainers, EObject[] objs) {
        return CloneUtil.cloneWithElementMap(targetContainers, objs, new HashMap());
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map) {
        return CloneUtil.cloneWithElementMap(targetContainer, obj, map, false, true);
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map, boolean cloneCrossModelExternalReferenced) {
        return CloneUtil.cloneWithElementMap(targetContainer, obj, map, false, true, cloneCrossModelExternalReferenced);
    }

    public static EObject[] cloneWithElementMap(EObject[] targetContainers, EObject[] objs, Map map) {
        return CloneUtil.cloneWithElementMap(targetContainers, objs, map, false, true);
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map, boolean isCut, boolean cloneExternalReferenced) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map, boolean isCut, boolean cloneExternalReferenced, boolean cloneCrossModelExternalReferenced) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static EObject[] cloneWithElementMap(EObject[] targetContainers, EObject[] objs, Map map, boolean isCut, boolean cloneExternalReferenced) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map, Collection containmentExclusion, Collection externalExclusion, boolean isCut, boolean cloneExternalReferenced, boolean cloneCrossModelExternalReferenced) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static EObject[] cloneWithElementMap(EObject targetContainer, EObject obj, Map map, Collection containmentExclusion, boolean isCut, boolean cloneExternalReferenced, boolean cloneCrossModelExternalReferenced) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static void updateReferencesToCloned(EObject[] clonedObjects, ResourceSet resourceSet) {
        int i = 0;
        while (i < clonedObjects.length) {
            EObject anObj = clonedObjects[i];
            Collection affectedObjs = EcoreUtil.UsageCrossReferencer.find((EObject)anObj, (ResourceSet)resourceSet);
            Iterator itor = affectedObjs.iterator();
            while (itor.hasNext()) {
                try {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)itor.next();
                    EObject referencingEObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    if (CloneUtil.underContainer(anObj, referencingEObject) || CloneUtil.underContainer(referencingEObject, anObj) || !eStructuralFeature.isChangeable() || eStructuralFeature.isMany()) continue;
                    referencingEObject.eSet(eStructuralFeature, (Object)anObj);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    private static EObject[] cloneWithElementMap2(EObject[] targetContainers, EObject[] objs, Map originalMap, Collection containmentExclusion, Collection externalExclusion, boolean isCut, boolean cloneExternalReferenced, boolean cloneCrossModelExternalReferenced) {
        EObject sourceContainer;
        EObject source;
        EObject targetContainer;
        LinkedHashMap<EObject, EObject> map = new LinkedHashMap<EObject, EObject>(originalMap);
        ArrayList<EObject> sourceContainers = new ArrayList<EObject>();
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        int i = 0;
        while (i < targetContainers.length) {
            Map containmentMap;
            EObject targetContainer2 = targetContainers[i];
            EObject source2 = objs[i];
            EObject sourceContainer2 = service.getContainer(source2);
            sourceContainers.add(sourceContainer2);
            EObject targetRoot = targetContainer2 == null ? null : service.getRootElement(targetContainer2);
            EObject sourceRoot = service.getRootElement(source2);
            if (targetContainer2 == null || targetRoot.eClass() != sourceRoot.eClass()) {
                if (isCut) {
                    map.put(source2, source2);
                } else {
                    Collection exclude = CloneUtil.findAllObjectsWithRequiredExternalReference(source2);
                    containmentMap = CloneUtil.cloneContainmentHierarchy(source2, exclude);
                    map.putAll(containmentMap);
                }
            } else {
                EObject commonContainer = CloneUtil.getLeastCommonContainer(sourceContainer2, targetContainer2);
                if (isCut) {
                    map.put(source2, source2);
                } else {
                    containmentMap = CloneUtil.cloneContainmentHierarchy(source2, containmentExclusion);
                    map.putAll(containmentMap);
                }
                if (commonContainer == null && !map.containsKey(sourceRoot)) {
                    map.put(sourceRoot, targetRoot);
                }
                CloneUtil.mapContainers(sourceContainer2, targetContainer2, map);
            }
            ++i;
        }
        LinkedList<EObject> containers = new LinkedList<EObject>();
        if (cloneExternalReferenced) {
            int i2 = 0;
            while (i2 < targetContainers.length) {
                targetContainer = targetContainers[i2];
                source = objs[i2];
                sourceContainer = service.getContainer(source);
                EObject targetRoot = targetContainer == null ? null : service.getRootElement(targetContainer);
                EObject sourceRoot = service.getRootElement(source);
                EObject commonContainer = CloneUtil.getLeastCommonContainer(sourceContainer, targetContainer);
                if (targetContainer != null && targetRoot.eClass() == sourceRoot.eClass() && targetContainer != null && targetRoot.eClass() == sourceRoot.eClass()) {
                    for (EObject o : CloneUtil.findAllRequiredExternalReferencedObjects(source, map)) {
                        if (!cloneCrossModelExternalReferenced && CloneUtil.isCrossModelObject(o, source) || externalExclusion.contains(o) || commonContainer != null && !CloneUtil.underContainer(o, commonContainer)) continue;
                        CloneUtil.findOrCloneExternalObject(o, targetRoot, containers, map);
                    }
                }
                ++i2;
            }
        }
        if (isCut) {
            int i3 = 0;
            while (i3 < targetContainers.length) {
                targetContainer = targetContainers[i3];
                source = objs[i3];
                sourceContainer = service.getContainer(source);
                if (targetContainer != null) {
                    CloneUtil.reParent(source, sourceContainer, targetContainer, map);
                }
                ++i3;
            }
        } else {
            HashSet exclusion = new HashSet(containmentExclusion);
            exclusion.addAll(externalExclusion);
            LinkedList keySet = new LinkedList(map.keySet());
            for (EObject obj : keySet) {
                if (sourceContainers.contains(obj)) continue;
                CloneUtil.copyReference(map, obj, exclusion, !cloneExternalReferenced || !cloneCrossModelExternalReferenced);
            }
        }
        int i4 = objs.length - 1;
        while (i4 >= 0) {
            EObject cloned = (EObject)map.get(objs[i4]);
            containers.add(0, cloned);
            EStructuralFeature feature = service.getContainmentFeature(objs[i4]);
            if (!(feature == null && CloneUtil.underContainer(cloned, targetContainers[i4]) || feature == null)) {
                if (feature.isMany()) {
                    Collection l = (Collection)targetContainers[i4].eGet(feature);
                    if (!l.contains(cloned)) {
                        l.add(cloned);
                    }
                } else {
                    targetContainers[i4].eSet(feature, (Object)cloned);
                }
            }
            --i4;
        }
        originalMap.putAll(map);
        EObject[] r = new EObject[containers.size()];
        containers.toArray(r);
        IPostprocessProvider exe = PostProcessingRegistryReader.getInstance().getPostProcessingExecutable();
        if (exe != null) {
            exe.postProcess(r);
        }
        return r;
    }

    private static EObject[] cloneWithElementMap2(EObject[] targetContainers, EObject[] objs, Map map, boolean isCut, boolean cloneExternalReferenced) {
        return CloneUtil.cloneWithElementMap2(targetContainers, objs, map, new LinkedList(), new LinkedList(), isCut, cloneExternalReferenced, true);
    }

    public static Collection findAllObjectsWithRequiredExternalReference(EObject container) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        HashSet<EObject> internal = new HashSet<EObject>();
        internal.add(container);
        internal.addAll(service.getAllContainedElements(container));
        HashSet goodObjects = new HashSet();
        HashSet badObjects = new HashSet();
        HashSet visited = new HashSet();
        for (EObject e : internal) {
            if (visited.contains(e)) continue;
            CloneUtil.hasRequiredExternalReference(e, internal, goodObjects, badObjects, visited);
        }
        return badObjects;
    }

    /*
     * Unable to fully structure code
     */
    public static EObject findMappedElement(EObject x, Map map) {
        if (map.containsKey(x)) {
            return (EObject)map.get(x);
        }
        service = ContainmentServiceImpl.INSTANCE;
        containers = service.getAllContainers(x);
        containers.add(x);
        it = containers.iterator();
        current = null;
        currentTarget = null;
        while (currentTarget == null && it.hasNext()) {
            current = (EObject)it.next();
            currentTarget = (EObject)map.get(current);
        }
        if (currentTarget != null) ** GOTO lbl24
        return null;
lbl-1000:
        // 1 sources

        {
            current = (EObject)it.next();
            like = (EObject)map.get(current);
            if (like == null && (like = CloneUtil.findChildLike(currentTarget, current)) != null) {
                map.put(current, like);
            }
            if (like == null) {
                return null;
            }
            currentTarget = like;
lbl24:
            // 2 sources

            ** while (it.hasNext())
        }
lbl25:
        // 1 sources

        return currentTarget;
    }

    public static Collection findAllRequiredExternalReferencedObjects(EObject container, Map map) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        HashSet<EObject> internal = new HashSet<EObject>();
        HashSet external = new HashSet();
        internal.add(container);
        internal.addAll(service.getAllContainedElements(container));
        for (EObject e : internal) {
            boolean useClientStrategy = false;
            if (e instanceof Privilege) {
                useClientStrategy = true;
            }
            CloneUtil.findRequiredExternalReferencedObjects(e, internal, external, map, useClientStrategy);
        }
        return external;
    }

    private static void findRequiredExternalReferencedObjects(EObject obj, Collection internal, Collection external, Map map, boolean useClientStrategy) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        for (EReference reference : obj.eClass().getEAllReferences()) {
            if (!CloneUtil.isRequired((EStructuralFeature)reference) && !CloneUtil.isRequired((EStructuralFeature)reference, obj)) continue;
            if (reference.isMany()) {
                Collection collection = null;
                if (useClientStrategy) {
                    try {
                        collection = ClientStrategyResolver.getInstance().getObjects(obj, (EStructuralFeature)reference, client);
                    }
                    catch (ClientStrategyResolverException clientStrategyResolverException) {
                        collection = (Collection)obj.eGet((EStructuralFeature)reference);
                    }
                } else {
                    collection = (Collection)obj.eGet((EStructuralFeature)reference);
                }
                for (EObject referenced : collection) {
                    if (internal.contains(referenced) || external.contains(referenced)) continue;
                    external.add(referenced);
                    if (CloneUtil.findMappedElement(referenced, map) == null) {
                        CloneUtil.findRequiredExternalReferencedObjects(referenced, internal, external, map, useClientStrategy);
                    }
                    for (EObject container : service.getAllContainers(referenced)) {
                        if (external.contains(container)) continue;
                        external.add(container);
                        if (CloneUtil.findMappedElement(container, map) != null) continue;
                        CloneUtil.findRequiredExternalReferencedObjects(container, internal, external, map, useClientStrategy);
                    }
                }
                continue;
            }
            EObject referenced = null;
            if (useClientStrategy) {
                referenced = (EObject)ClientStrategyResolver.getInstance().getObject(obj, (EStructuralFeature)reference, client);
            }
            if (referenced == null) {
                referenced = (EObject)obj.eGet((EStructuralFeature)reference);
            }
            if (referenced == null || internal.contains(referenced) || external.contains(referenced)) continue;
            external.add(referenced);
            if (CloneUtil.findMappedElement(referenced, map) == null) {
                CloneUtil.findRequiredExternalReferencedObjects(referenced, internal, external, map, useClientStrategy);
            }
            for (EObject container : service.getAllContainers(referenced)) {
                if (external.contains(container)) continue;
                external.add(container);
                if (CloneUtil.findMappedElement(container, map) != null) continue;
                CloneUtil.findRequiredExternalReferencedObjects(container, internal, external, map, useClientStrategy);
            }
        }
    }

    public static EObject findOrCloneExternalObject(EObject x, EObject targetRoot, Collection addedContainers, Map clonedMap) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        List containers = service.getAllContainers(x);
        containers.add(x);
        Iterator it = containers.iterator();
        EObject current = null;
        EObject currentTarget = targetRoot;
        while (it.hasNext()) {
            current = (EObject)it.next();
            EObject like = (EObject)clonedMap.get(current);
            if (like == null && (like = CloneUtil.findChildLike(currentTarget, current)) != null) {
                clonedMap.put(current, like);
            }
            if (like == null) {
                ICloningInfoProvider cip = CloneUtil.getProvider(current);
                if (cip != null && cip.cloneContainmentHierarchyOnExtRef(current)) {
                    Map containmentMap = CloneUtil.cloneContainmentHierarchy(current, new LinkedList());
                    clonedMap.putAll(containmentMap);
                    currentTarget = (EObject)containmentMap.get(current);
                    addedContainers.add(currentTarget);
                    continue;
                }
                EObject cloned = CloneUtil.cloneSingleObject(current);
                clonedMap.put(current, cloned);
                currentTarget = cloned;
                addedContainers.add(cloned);
                continue;
            }
            currentTarget = like;
        }
        return currentTarget;
    }

    public static EObject findChildLike(EObject container, EObject like) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        EStructuralFeature feature = service.getContainmentFeature(like);
        if (feature != null && !feature.getContainerClass().isAssignableFrom(container.getClass())) {
            return null;
        }
        if (feature == null) {
            for (EObject child : service.getContainedElements(container)) {
                if (service.getContainmentFeature(child) != null || !CloneUtil.match(child, like)) continue;
                return child;
            }
        } else if (feature.isMany()) {
            for (EObject child : (Collection)container.eGet(feature)) {
                if (!CloneUtil.match(child, like)) continue;
                return child;
            }
            for (EObject child : service.getContainedElements(container)) {
                if (!CloneUtil.match(child, like)) continue;
                return child;
            }
        } else {
            EObject child = (EObject)container.eGet(feature);
            return child;
        }
        return null;
    }

    private static boolean match(EObject e1, EObject e2) {
        ContainmentService service;
        EStructuralFeature feature;
        if (e1.eClass() != e2.eClass()) {
            return false;
        }
        if (SQLAccessControlPackage.eINSTANCE.getPrivilege().isSuperTypeOf(e1.eClass())) {
            return AccessControlUtilities.match((Privilege)e1, (Privilege)e2);
        }
        if (SQLConstraintsPackage.eINSTANCE.getPrimaryKey().isSuperTypeOf(e1.eClass()) && ((PrimaryKey)e1).getMembers().size() == ((PrimaryKey)e2).getMembers().size()) {
            return true;
        }
        if ("com.ibm.db.models.logical.PrimaryKey".equals(e1.eClass().getInstanceClassName())) {
            return true;
        }
        if (SQLSchemaPackage.eINSTANCE.getDependency().isSuperTypeOf(e1.eClass())) {
            return CloneUtil.matchDependency((Dependency)e1, (Dependency)e2);
        }
        if (e1 instanceof ENamedElement) {
            String name1 = ((ENamedElement)e1).getName();
            String name2 = ((ENamedElement)e2).getName();
            if (name1 != null) {
                return name1.equals(name2);
            }
            if (name2 != null) {
                return name2.equals(name1);
            }
        }
        if ((feature = (service = ContainmentServiceImpl.INSTANCE).getContainmentFeature(e1)).isMany()) {
            Object v1 = service.getContainer(e1).eGet(feature);
            Object v2 = service.getContainer(e2).eGet(feature);
            if (v1 instanceof List) {
                return ((List)v1).indexOf(e1) == ((List)v2).indexOf(e2);
            }
            return true;
        }
        return true;
    }

    private static boolean matchDependency(Dependency d1, Dependency d2) {
        EObject e1 = d1.getTargetEnd();
        EObject e2 = d2.getTargetEnd();
        if (e1.eClass() != e2.eClass()) {
            return false;
        }
        if (e1 instanceof ENamedElement) {
            String name1 = ((ENamedElement)e1).getName();
            String name2 = ((ENamedElement)e2).getName();
            if (name1 != null) {
                return name1.equals(name2);
            }
            if (name2 != null) {
                return name2.equals(name1);
            }
        }
        return false;
    }

    public static EObject getLeastCommonContainer(EObject obj1, EObject obj2) {
        if (obj1 == null || obj2 == null) {
            return null;
        }
        if (obj1 == obj2) {
            return obj1;
        }
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        EObject common = null;
        List containers1 = service.getAllContainers(obj1);
        List containers2 = service.getAllContainers(obj2);
        Iterator i1 = containers1.iterator();
        Iterator i2 = containers2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object c2;
            Object c1 = i1.next();
            if (c1 != (c2 = i2.next())) continue;
            common = (EObject)c1;
        }
        return common;
    }

    public static boolean underContainer(EObject obj, EObject container) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        return service.getAllContainers(obj).contains(container);
    }

    public static void mapContainers(EObject srcContainer, EObject tgtContainer, Map map) {
        if (srcContainer == null || tgtContainer == null) {
            return;
        }
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        List srcContainers = service.getAllContainers(srcContainer);
        srcContainers.add(srcContainer);
        List tgtContainers = service.getAllContainers(tgtContainer);
        tgtContainers.add(tgtContainer);
        if (srcContainers.size() == tgtContainers.size()) {
            Iterator src = srcContainers.iterator();
            Iterator tgt = tgtContainers.iterator();
            while (src.hasNext()) {
                map.put(src.next(), tgt.next());
            }
        } else if (!map.containsKey(srcContainer)) {
            map.put(srcContainer, tgtContainer);
        }
    }

    private static boolean hasRequiredExternalReference(EObject obj, Collection internals, Collection goodObjects, Collection badObjects, Collection visited) {
        visited.add(obj);
        for (EReference reference : obj.eClass().getEAllReferences()) {
            boolean good;
            if (!CloneUtil.isRequired((EStructuralFeature)reference) && !CloneUtil.isRequired((EStructuralFeature)reference, obj)) continue;
            if (reference.isMany()) {
                for (EObject referenced : (Collection)obj.eGet((EStructuralFeature)reference)) {
                    boolean good2;
                    if (badObjects.contains(referenced)) {
                        return true;
                    }
                    if (goodObjects.contains(referenced) || visited.contains(referenced) || internals.contains(referenced) && (good2 = CloneUtil.hasRequiredExternalReference(referenced, internals, goodObjects, badObjects, visited))) continue;
                    badObjects.add(obj);
                    return true;
                }
                continue;
            }
            EObject referenced = (EObject)obj.eGet((EStructuralFeature)reference);
            if (referenced == null) continue;
            if (badObjects.contains(referenced)) {
                return true;
            }
            if (goodObjects.contains(referenced) || visited.contains(referenced) || internals.contains(referenced) && (good = CloneUtil.hasRequiredExternalReference(referenced, internals, goodObjects, badObjects, visited))) continue;
            badObjects.add(obj);
            return true;
        }
        goodObjects.add(obj);
        return false;
    }

    public static void copyReference(Map map, EObject src, boolean keepOriginalReference) {
        CloneUtil.copyReference(map, src, new HashSet(), keepOriginalReference);
    }

    public static void copyReference(Map map, EObject src, Collection exclude, boolean keepOriginalReference) {
        CloneUtil.copyReference(map, src, new HashSet(), keepOriginalReference, null);
    }

    public static void copyReference(Map map, EObject src, Collection exclude, boolean keepOriginalReference, EObject[] copiedObjects) {
        Iterator it = src.eClass().getEAllStructuralFeatures().iterator();
        EObject cloned = (EObject)map.get(src);
        while (it.hasNext()) {
            EStructuralFeature reference = (EStructuralFeature)it.next();
            if (!CloneUtil.isRequired(reference) && !CloneUtil.isRequired(reference, src) || !reference.isChangeable() || reference.isDerived()) continue;
            if (copiedObjects != null && copiedObjects.length != 0 && reference.equals(SQLSchemaPackage.eINSTANCE.getSQLObject_Privileges())) {
                boolean bypass = true;
                EObject[] eObjectArray = copiedObjects;
                int n = copiedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject obj = eObjectArray[n2];
                    if (obj == src) {
                        bypass = false;
                    }
                    ++n2;
                }
                if (bypass) continue;
            }
            if (reference instanceof EReference) {
                Object targetReference;
                if (reference.isMany()) {
                    Collection srcCollection = (Collection)src.eGet(reference);
                    if (srcCollection.size() <= 0) continue;
                    if (srcCollection instanceof EObjectEList) {
                        EObject srcContainer = ((EObjectEList)srcCollection).getEObject();
                        Collection targetCollection = (Collection)cloned.eGet(reference);
                        EObject targetContainer = ((EObjectEList)targetCollection).getEObject();
                        if (!targetContainer.getClass().isAssignableFrom(srcContainer.getClass())) continue;
                        Vector elements = new Vector();
                        if (targetCollection.size() != 0) continue;
                        for (Object srcReference : srcCollection) {
                            EObject mapped;
                            if (exclude.contains(srcReference)) continue;
                            if (map.containsKey(srcReference) && srcReference != map.get(srcReference)) {
                                elements.add(map.get(srcReference));
                                continue;
                            }
                            if (!CloneUtil.isRequired(reference) && !CloneUtil.isRequired(reference, src) || (mapped = CloneUtil.findMappedElement((EObject)srcReference, map)) == null || mapped == srcReference) continue;
                            elements.add(map.get(srcReference));
                        }
                        int i = 0;
                        while (i < elements.size()) {
                            targetCollection.add(elements.elementAt(i));
                            ++i;
                        }
                        continue;
                    }
                    if (!(srcCollection instanceof EMap) || !(((EMap)srcCollection).get(0) instanceof EStringToStringMapEntryImpl)) continue;
                    EMap targetCollection = (EMap)cloned.eGet(reference);
                    Set keys = ((EMap)srcCollection).keySet();
                    keys.iterator();
                    for (String key : keys) {
                        targetCollection.put((Object)key, ((EMap)srcCollection).get((Object)key));
                    }
                    continue;
                }
                EObject srcReference = (EObject)src.eGet(reference);
                if (srcReference == null || exclude.contains(srcReference) || (targetReference = cloned.eGet(reference)) != null) continue;
                if (map.containsKey(srcReference)) {
                    cloned.eSet(reference, map.get(srcReference));
                    continue;
                }
                if (!CloneUtil.isRequired(reference)) continue;
                EObject mapped = CloneUtil.findMappedElement(srcReference, map);
                if (mapped != null) {
                    cloned.eSet(reference, (Object)mapped);
                    continue;
                }
                if (!CloneUtil.isShallowCopyRecommended(src, reference, keepOriginalReference)) continue;
                cloned.eSet(reference, (Object)srcReference);
                continue;
            }
            if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)reference)) continue;
            FeatureMap featureMap = (FeatureMap)src.eGet(reference);
            FeatureMap copyFeatureMap = (FeatureMap)cloned.eGet(reference);
            for (FeatureMap.Entry featureMapEntry : featureMap) {
                EStructuralFeature feature = featureMapEntry.getEStructuralFeature();
                if (feature instanceof EReference) {
                    Object referencedEObject = featureMapEntry.getValue();
                    Object copyReferencedEObject = map.get(referencedEObject);
                    copyFeatureMap.add(feature, copyReferencedEObject == null ? referencedEObject : copyReferencedEObject);
                    continue;
                }
                copyFeatureMap.add((Object)featureMapEntry);
            }
        }
    }

    public static boolean isShallowCopyRecommended(EObject src, EStructuralFeature reference, boolean keepOriginalReference) {
        if (!keepOriginalReference) {
            return false;
        }
        boolean isRequired = true;
        if ("Column".equals(reference.getEContainingClass().getName()) && "identitySpecifier".equals(reference.getName())) {
            isRequired = false;
        }
        return isRequired;
    }

    public static Map cloneContainmentHierarchy(EObject obj, Collection exclude) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        LinkedHashMap<EObject, EObject> map = new LinkedHashMap<EObject, EObject>();
        if (exclude.contains(obj)) {
            return map;
        }
        EObject cloned = CloneUtil.cloneSingleObject(obj);
        map.put(obj, cloned);
        Iterator it = service.getContainedElements(obj).iterator();
        HashSet children = new HashSet();
        while (it.hasNext()) {
            Object o = it.next();
            if (exclude.contains(o)) continue;
            children.add(o);
        }
        while (!children.isEmpty()) {
            EObject child = (EObject)children.iterator().next();
            EStructuralFeature feature = service.getContainmentFeature(child);
            if (feature != null && feature.getContainerClass().isAssignableFrom(obj.getClass())) {
                if (feature.isMany()) {
                    Collection l = (Collection)cloned.eGet(feature);
                    it = ((Collection)obj.eGet(feature)).iterator();
                    Vector<EObject> childrenVec = new Vector<EObject>();
                    while (it.hasNext()) {
                        EObject c = (EObject)it.next();
                        if (!children.contains(c)) continue;
                        childrenVec.add(c);
                    }
                    int iVec = 0;
                    while (iVec < childrenVec.size()) {
                        EObject c = (EObject)childrenVec.get(iVec);
                        children.remove(c);
                        map.putAll(CloneUtil.cloneContainmentHierarchy(c, exclude));
                        l.add(map.get(c));
                        ++iVec;
                    }
                    continue;
                }
                map.putAll(CloneUtil.cloneContainmentHierarchy(child, exclude));
                cloned.eSet(feature, map.get(child));
                children.remove(child);
                continue;
            }
            children.remove(child);
        }
        return map;
    }

    public static EObject cloneSingleObject(EObject src) {
        EClass c = src.eClass();
        EObject target = c.getEPackage().getEFactoryInstance().create(c);
        for (EAttribute a : c.getEAllAttributes()) {
            if (!a.isChangeable() || a.isDerived()) continue;
            CloneUtil.copyAttribute(a, src, target);
        }
        return target;
    }

    private static void copyAttribute(EAttribute attribute, EObject src, EObject target) {
        if (src.eIsSet((EStructuralFeature)attribute)) {
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute)) {
                FeatureMap srcFeatureMap = (FeatureMap)src.eGet((EStructuralFeature)attribute);
                FeatureMap tgtFeatureMap = (FeatureMap)src.eGet((EStructuralFeature)attribute);
                for (FeatureMap.Entry entry : srcFeatureMap) {
                    EStructuralFeature feature = entry.getEStructuralFeature();
                    if (feature instanceof EReference) continue;
                    tgtFeatureMap.add((Object)entry);
                }
            } else if (attribute.isMany()) {
                ((Collection)target.eGet((EStructuralFeature)attribute)).addAll((Collection)src.eGet((EStructuralFeature)attribute));
            } else {
                String attrType = attribute.getName();
                if (!"namespace".equalsIgnoreCase(attrType) && !"namespaceSupported".equalsIgnoreCase(attrType)) {
                    target.eSet((EStructuralFeature)attribute, src.eGet((EStructuralFeature)attribute));
                }
            }
        }
    }

    public static boolean isRequired(EStructuralFeature feature) {
        Boolean booleanObj;
        Hashtable featureNames = (Hashtable)requiredFeatures.get(feature.getEContainingClass().getName());
        if (featureNames != null && (booleanObj = (Boolean)featureNames.get(feature.getName())) != null) {
            return booleanObj;
        }
        if (feature.isRequired()) {
            return true;
        }
        if (!feature.isMany() && feature instanceof EReference) {
            EReference ref = (EReference)feature;
            EReference opposite = ref.getEOpposite();
            if (opposite == null) {
                return true;
            }
            if (opposite.isMany()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRequired(EStructuralFeature feature, EObject obj) {
        return feature != null && obj instanceof CharacterStringDataType && feature.getName().equals("eAnnotations");
    }

    private static void reParent(EObject obj, EObject sourceContainer, EObject targetContainer, Map map) {
        if (targetContainer == null) {
            return;
        }
        EObject sourceObj = obj;
        EObject cloned = (EObject)map.get(sourceObj);
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        EStructuralFeature feature = service.getContainmentFeature(obj);
        if (feature == null) {
            return;
        }
        if (feature.isMany()) {
            Collection l = (Collection)targetContainer.eGet(feature);
            if (!l.contains(cloned)) {
                l.add(cloned);
            }
        } else {
            targetContainer.eSet(feature, (Object)cloned);
        }
        if (sourceContainer == null || targetContainer == null) {
            return;
        }
        Resource srcResource = sourceContainer.eResource();
        Resource targetResource = targetContainer.eResource();
        if (srcResource != null && targetResource != null && srcResource != targetResource) {
            if (cloned.eContainer() != targetContainer) {
                XMLResourceImpl srcXmlResource;
                String srcID = null;
                if (srcResource instanceof XMLResourceImpl && targetResource instanceof XMLResourceImpl && (srcID = (srcXmlResource = (XMLResourceImpl)srcResource).getID(sourceObj)) != null) {
                    XMLResourceImpl targetXmlResource = (XMLResourceImpl)targetResource;
                    targetXmlResource.setID(cloned, srcID);
                }
                targetResource.getContents().add((Object)cloned);
                srcResource.getContents().remove((Object)sourceObj);
            }
            CloneUtil.reResource(cloned);
        }
    }

    public static void reResource(EObject obj) {
        ContainmentService service = ContainmentServiceImpl.INSTANCE;
        Resource targetResource = obj.eResource();
        for (EObject child : service.getContainedElements(obj)) {
            if (obj.eContents().contains((Object)child)) {
                CloneUtil.reResource(child);
                continue;
            }
            if (targetResource.getContents().contains((Object)child)) continue;
            targetResource.getContents().add((Object)child);
            CloneUtil.reResource(child);
        }
    }

    public static boolean isCrossModelObject(EObject obj1, EObject obj2) {
        Resource srcResource = obj1.eResource();
        Resource targetResource = obj2.eResource();
        return srcResource != null && targetResource != null && srcResource != targetResource;
    }

    private static Hashtable getProviders() {
        Hashtable packages = new Hashtable();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "CloningInfoProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                block7: {
                    if (configElements[j].getName().equals("cloning")) {
                        String packageURI = configElements[j].getAttribute("package");
                        String className = configElements[j].getAttribute("class");
                        ICloningInfoProvider provider = null;
                        try {
                            provider = (ICloningInfoProvider)configElements[j].createExecutableExtension("provider");
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the cloning info provider for " + className + " in " + packageURI, (Throwable)e);
                            RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                            break block7;
                        }
                        if (packages.containsKey(packageURI)) {
                            ((Hashtable)packages.get(packageURI)).put(className, provider);
                        } else {
                            Hashtable<String, ICloningInfoProvider> classNames = new Hashtable<String, ICloningInfoProvider>();
                            classNames.put(className, provider);
                            packages.put(packageURI, classNames);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return packages;
    }

    private static ICloningInfoProvider getProvider(EObject eObj) {
        Hashtable classNames;
        EClass clazz = eObj.eClass();
        String uri = clazz.getEPackage().getNsURI();
        if (packages.containsKey(uri) && (classNames = (Hashtable)packages.get(uri)).containsKey(clazz.getName())) {
            return (ICloningInfoProvider)classNames.get(clazz.getName());
        }
        return null;
    }

    private static Hashtable getRequiredFeatures() {
        Hashtable features = new Hashtable();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "requiredFeature");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("featureInfo")) {
                    String containingClass = configElements[j].getAttribute("containingClass");
                    String featureName = configElements[j].getAttribute("featureName");
                    String isRequired = configElements[j].getAttribute("isRequired");
                    if (features.containsKey(containingClass)) {
                        ((Hashtable)features.get(containingClass)).put(featureName, Boolean.valueOf(isRequired));
                    } else {
                        Hashtable<String, Boolean> featureNames = new Hashtable<String, Boolean>();
                        featureNames.put(featureName, Boolean.valueOf(isRequired));
                        features.put(containingClass, featureNames);
                    }
                }
                ++j;
            }
            ++i;
        }
        return features;
    }

    public static EObject[] cloneWithElementMap(EObject d2, EObject u, Map map, Collection containmentExclusion, Collection externalExclusion, boolean cloneCrossModelReference) {
        ArrayList result = new ArrayList(1);
        return (EObject[])result.toArray(new Object[1])[0];
    }

    public static EObject[] clone2Target(EObject targetContainer, EObject obj) {
        ArrayList<EObject[]> result = new ArrayList<EObject[]>(1);
        boolean isCut = false;
        boolean cloneExternalReferenced = true;
        result.add(CloneUtil.cloneWithElementMap2(new EObject[]{targetContainer}, new EObject[]{obj}, new HashMap(), new LinkedList(), new LinkedList(), isCut, cloneExternalReferenced, true));
        return (EObject[])result.toArray(new Object[1])[0];
    }
}

