/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.service;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.junit5.service.ServiceExtension;
import org.osgi.test.junit5.service.ServiceSource;

public class ServiceArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<ServiceSource> {
    private ServiceSource source;

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List targetTypes = context.getElement().filter(Method.class::isInstance).map(Method.class::cast).map(Executable::getParameters).map(params -> Arrays.stream(params).map(TargetType::of).collect(Collectors.toList())).orElse(Collections.emptyList());
        try {
            ServiceConfiguration<?> sc = ServiceExtension.getServiceConfiguration(this.source.serviceType(), this.source.filter(), this.source.filterArguments(), this.source.cardinality(), this.source.timeout(), context);
            Stream<Object[]> arguments = sc.getServiceReferences().stream().filter(Objects::nonNull).map(reference -> targetTypes.stream().map(targetType -> {
                if (targetType.matches(this.source.serviceType())) {
                    return sc.getTracked().get(reference);
                }
                if (targetType.matches(ServiceReference.class, new Type[]{this.source.serviceType()})) {
                    return reference;
                }
                if (targetType.matches(Dictionary.class, new Type[]{String.class, Object.class})) {
                    Hashtable<String, Object> dict = new Hashtable<String, Object>();
                    for (String key : reference.getPropertyKeys()) {
                        ((Dictionary)dict).put(key, reference.getProperty(key));
                    }
                    return dict;
                }
                if (targetType.matches(Map.class, new Type[]{String.class, Object.class})) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : reference.getPropertyKeys()) {
                        map.put(key, reference.getProperty(key));
                    }
                    return map;
                }
                return this;
            }).filter(argument -> argument != this).toArray());
            return arguments.map(Arguments::of);
        }
        catch (AssertionError e) {
            throw new ParameterResolutionException("@ServiceSource: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public void accept(ServiceSource source) {
        this.source = source;
    }
}

