/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.stream;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.test.common.stream.AbstractWhile;

public final class TakeWhile<T>
extends AbstractWhile<T> {
    private boolean take = true;

    public static <O> Stream<O> takeWhile(Stream<O> stream, Predicate<? super O> predicate) {
        return (Stream)StreamSupport.stream(new TakeWhile<O>(stream.spliterator(), predicate), stream.isParallel()).onClose(stream::close);
    }

    private TakeWhile(Spliterator<T> spliterator, Predicate<? super T> predicate) {
        super(spliterator, predicate);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (this.take) {
            while (this.spliterator.tryAdvance(this) && this.predicate.test(this.item)) {
                action.accept(this.item);
            }
            this.take = false;
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.take) {
            if (this.spliterator.tryAdvance(this) && this.predicate.test(this.item)) {
                action.accept(this.item);
                return true;
            }
            this.take = false;
        }
        return false;
    }
}

