/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;
import org.osgi.framework.Version;

public class XbaseUIValidator
extends AbstractDeclarativeValidator {
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private IJavaElementFinder javaElementFinder;
    private static final MethodHandle GET_ROOT_PATH_TO_RESOLVED_ENTRIES = XbaseUIValidator.findAccessor();

    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{TypesPackage.eINSTANCE, XtypePackage.eINSTANCE, XbasePackage.eINSTANCE});
    }

    @Check
    public void checkRestrictedType(XImportDeclaration importDeclaration) {
        if (this.isRestrictionCheckIgnored()) {
            return;
        }
        JvmDeclaredType importedType = importDeclaration.getImportedType();
        if (importedType instanceof JvmDeclaredType) {
            this.checkRestrictedType((EObject)importDeclaration, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, importedType);
        }
    }

    @Check
    public void checkRestrictedType(XConstructorCall constructorCall) {
        if (this.isRestrictionCheckIgnored()) {
            return;
        }
        JvmConstructor constructor = constructorCall.getConstructor();
        if (constructor == null) {
            return;
        }
        JvmDeclaredType declaringType = constructor.getDeclaringType();
        this.checkRestrictedType((EObject)constructorCall, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, declaringType);
    }

    @Check
    public void checkRestrictedType(XAbstractFeatureCall featureCall) {
        if (this.isRestrictionCheckIgnored()) {
            return;
        }
        if (!featureCall.isTypeLiteral()) {
            return;
        }
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature instanceof JvmDeclaredType) {
            JvmDeclaredType referencedType = (JvmDeclaredType)feature;
            if (featureCall instanceof XMemberFeatureCall) {
                this.checkRestrictedType((EObject)featureCall, null, referencedType);
            } else {
                this.checkRestrictedType((EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, referencedType);
            }
        }
    }

    @Check
    public void checkRestrictedType(JvmTypeReference typeReference) {
        JvmType type;
        if (this.isRestrictionCheckIgnored()) {
            return;
        }
        if (typeReference != null && typeReference.eResource() != null && typeReference.eResource().getResourceSet() != null && (type = typeReference.getType()) instanceof JvmDeclaredType) {
            if (typeReference instanceof JvmParameterizedTypeReference) {
                this.checkRestrictedType((EObject)typeReference, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, (JvmDeclaredType)type);
            } else {
                this.checkRestrictedType((EObject)typeReference, null, (JvmDeclaredType)type);
            }
        }
    }

    protected boolean isRestrictionCheckIgnored() {
        return this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference") && this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference");
    }

    protected void checkRestrictedType(EObject context, EStructuralFeature feature, JvmDeclaredType typeToCheck) {
        Map validationContext = (Map)this.getContext().get(RestrictionKind.class);
        if (validationContext == null) {
            validationContext = Maps.newHashMap();
            this.getContext().put(RestrictionKind.class, validationContext);
        }
        RestrictionKind restriction = null;
        String javaProjectName = null;
        Pair cached = (Pair)validationContext.get(typeToCheck);
        if (cached != null) {
            restriction = (RestrictionKind)((Object)cached.getKey());
            javaProjectName = (String)cached.getValue();
        }
        if (restriction == null) {
            IJavaElement javaElement = this.javaElementFinder.findElementFor((JvmIdentifiableElement)typeToCheck);
            if (javaElement == null || !(javaElement instanceof IType)) {
                validationContext.put(typeToCheck, Pair.of((Object)((Object)RestrictionKind.VALID), null));
                return;
            }
            IJavaProject javaProject = javaElement.getJavaProject();
            if (javaProject != null) {
                javaProjectName = javaProject.getElementName();
            }
            restriction = this.computeRestriction(this.projectProvider.getJavaProject(context.eResource().getResourceSet()), (IType)javaElement);
            validationContext.put(typeToCheck, Pair.of((Object)((Object)restriction), (Object)javaProjectName));
        }
        if (restriction == RestrictionKind.FORBIDDEN) {
            if (javaProjectName == null && (javaProject = this.projectProvider.getJavaProject(context.eResource().getResourceSet())) != null) {
                javaProjectName = javaProject.getElementName();
            }
            this.addIssue("Access restriction: The type " + typeToCheck.getSimpleName() + " is not accessible due to restriction on required project " + javaProjectName, context, feature, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
        } else if (restriction == RestrictionKind.DISCOURAGED) {
            if (javaProjectName == null && (javaProject = this.projectProvider.getJavaProject(context.eResource().getResourceSet())) != null) {
                javaProjectName = javaProject.getElementName();
            }
            this.addIssue("Discouraged access: The type " + typeToCheck.getSimpleName() + " is not accessible due to restriction on required project " + javaProjectName, context, feature, "org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference", new String[0]);
        }
    }

    protected RestrictionKind computeRestriction(IJavaProject project, IType type) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
            if (root == null) {
                return RestrictionKind.VALID;
            }
            IClasspathEntry entry = this.getResolvedClasspathEntry(project, root);
            if (entry == null) {
                return RestrictionKind.VALID;
            }
            IAccessRule[] rules = entry.getAccessRules();
            String typePath = type.getFullyQualifiedName().replace('.', '/');
            char[] typePathAsArray = typePath.toCharArray();
            IAccessRule[] iAccessRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                IAccessRule rule = iAccessRuleArray[n2];
                char[] patternArray = ((ClasspathAccessRule)rule).pattern;
                if (CharOperation.pathMatch((char[])patternArray, (char[])typePathAsArray, (boolean)true, (char)'/')) {
                    if (rule.getKind() == 2) {
                        return RestrictionKind.DISCOURAGED;
                    }
                    if (rule.getKind() == 1) {
                        return RestrictionKind.FORBIDDEN;
                    }
                    return RestrictionKind.VALID;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return RestrictionKind.VALID;
    }

    protected IClasspathEntry getResolvedClasspathEntry(IJavaProject javaProject, IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry result = null;
        JavaProject castedProject = (JavaProject)javaProject;
        castedProject.getResolvedClasspath();
        Map<IPath, IClasspathEntry> rootPathToResolvedEntries = this.getRootPathToResolvedEntries(castedProject.getPerProjectInfo());
        if (rootPathToResolvedEntries != null && (result = rootPathToResolvedEntries.get(root.getPath())) == null) {
            result = rootPathToResolvedEntries.get(root.getJavaProject().getPath());
        }
        return result;
    }

    private static MethodHandle findAccessor() {
        try {
            if (JavaCore.getPlugin().getBundle().getVersion().compareTo(new Version(3, 39, 0)) >= 0) {
                return MethodHandles.lookup().findVirtual(JavaModelManager.PerProjectInfo.class, "getRootPathToResolvedEntries", MethodType.methodType(Map.class));
            }
            return MethodHandles.lookup().findGetter(JavaModelManager.PerProjectInfo.class, "rootPathToResolvedEntries", Map.class);
        }
        catch (Exception e) {
            return MethodHandles.dropArguments(MethodHandles.constant(Map.class, Collections.emptyMap()), 0, new Class[]{JavaModelManager.PerProjectInfo.class});
        }
    }

    protected Map<IPath, IClasspathEntry> getRootPathToResolvedEntries(JavaModelManager.PerProjectInfo info) throws JavaModelException {
        try {
            return GET_ROOT_PATH_TO_RESOLVED_ENTRIES.invoke(info);
        }
        catch (Throwable t) {
            throw new JavaModelException(Status.error((String)t.getMessage(), (Throwable)t));
        }
    }

    private static enum RestrictionKind {
        FORBIDDEN,
        DISCOURAGED,
        VALID;

    }
}

