/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.resource.JvmElementAtOffsetHelper;

public abstract class AbstractJvmElementHandler
extends AbstractHandler {
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private JvmElementAtOffsetHelper jvmElementAtOffsetHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            editor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork<Void, XtextResource>(){

                public Void exec(XtextResource resource) throws Exception {
                    IJavaElement javaType;
                    JvmIdentifiableElement jvmIdentifiable = AbstractJvmElementHandler.this.jvmElementAtOffsetHelper.getJvmIdentifiableElement(resource, selection.getOffset());
                    if (jvmIdentifiable != null && (javaType = AbstractJvmElementHandler.this.javaElementFinder.findElementFor(jvmIdentifiable)) != null) {
                        AbstractJvmElementHandler.this.openPresentation(editor, javaType, (EObject)jvmIdentifiable);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    protected abstract void openPresentation(XtextEditor var1, IJavaElement var2, EObject var3);
}

