/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class FunctionLibrary
implements org.eclipse.wst.xml.xpath2.api.FunctionLibrary {
    private String _namespace;
    private Map _functions;
    private StaticContext _sc;
    private DynamicContext _dc;

    public FunctionLibrary(String ns) {
        this._namespace = ns;
        this._functions = new Hashtable();
        this._sc = null;
        this._dc = null;
    }

    public void add_function(Function x) {
        x.name().set_namespace(this._namespace);
        this._functions.put(x.signature(), x);
    }

    public boolean function_exists(QName name, int arity) {
        return this.function(name, arity) != null;
    }

    public Function function(QName name, int arity) {
        Function f = (Function)this._functions.get(Function.signature(name, arity));
        if (f != null || arity == -1) {
            return f;
        }
        f = this.function(name, -1);
        if (f == null) {
            return null;
        }
        if (f.matches_arity(arity)) {
            return f;
        }
        return null;
    }

    public String namespace() {
        return this._namespace;
    }

    public void set_static_context(StaticContext sc) {
        this._sc = sc;
    }

    public void set_dynamic_context(DynamicContext dc) {
        this._dc = dc;
    }

    public StaticContext static_context() {
        return this._sc;
    }

    public DynamicContext dynamic_context() {
        return this._dc;
    }

    @Override
    public boolean functionExists(String name, int arity) {
        return this.function_exists(new QName(null, name, this.namespace()), arity);
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.Function resolveFunction(String localName, int arity) {
        return this.function(new QName("f", localName, this.namespace()), arity);
    }

    @Override
    public String getNamespace() {
        return this.namespace();
    }
}

