/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;

public class ConsolePseudoProcess
extends PlatformObject
implements IProcess {
    private final ILaunch launch;
    private final Retransmitter outputMonitor;
    private final ITerminate connectionTerminate;
    private final String name;
    private Map<String, String> attributes = null;
    private final IStreamsProxy streamsProxy = new IStreamsProxy(){

        public IStreamMonitor getErrorStreamMonitor() {
            return NullStreamMonitor.INSTANCE;
        }

        public IStreamMonitor getOutputStreamMonitor() {
            return ConsolePseudoProcess.this.outputMonitor;
        }

        public void write(String input) {
        }
    };

    public ConsolePseudoProcess(ILaunch launch, String name, Retransmitter retransmitter, ITerminate connectionTerminate) {
        this.launch = launch;
        this.name = name;
        this.outputMonitor = retransmitter;
        this.outputMonitor.consolePseudoProcess = this;
        this.connectionTerminate = connectionTerminate;
        this.launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    public Writer getOutputWriter() {
        return this.outputMonitor;
    }

    public String getLabel() {
        return this.name;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean isTerminated() {
        return this.connectionTerminate.isTerminated();
    }

    public void terminate() throws DebugException {
        this.connectionTerminate.terminate();
    }

    public boolean canTerminate() {
        return this.connectionTerminate.canTerminate();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public synchronized void setAttribute(String key, String value) {
        String origVal;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(1);
        }
        if ((origVal = this.attributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.attributes.put(key, value);
        this.fireChangeEvent();
    }

    public synchronized String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return 0;
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Process hasn't been terminated yet"));
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    private void fireTerminateEvent() {
        this.outputMonitor.flush();
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    private void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(adapter);
    }

    private static class NullStreamMonitor
    implements IStreamMonitor {
        static final NullStreamMonitor INSTANCE = new NullStreamMonitor();

        private NullStreamMonitor() {
        }

        public void addListener(IStreamListener listener) {
        }

        public String getContents() {
            return null;
        }

        public void removeListener(IStreamListener listener) {
        }
    }

    public static class Retransmitter
    extends Writer
    implements IStreamMonitor {
        private StringWriter writer = new StringWriter();
        private boolean isFlushing = false;
        private final List<IStreamListener> listeners = new ArrayList<IStreamListener>(2);
        private volatile ConsolePseudoProcess consolePseudoProcess = null;

        public synchronized void addListener(IStreamListener listener) {
            this.listeners.add(listener);
        }

        public String getContents() {
            return null;
        }

        public synchronized void removeListener(IStreamListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public synchronized void flush() {
            if (!this.isFlushing) {
                return;
            }
            String text = this.writer.toString();
            int pos = text.lastIndexOf(10);
            if (pos == -1) {
                return;
            }
            int lastLinePos = pos + 1;
            String readyText = text.substring(0, lastLinePos);
            this.writer = new StringWriter();
            if (lastLinePos != text.length()) {
                String rest = text.substring(lastLinePos);
                this.writer.append(rest);
            }
            for (IStreamListener listener : this.listeners) {
                listener.streamAppended(readyText, (IStreamMonitor)this);
            }
        }

        @Override
        public synchronized void close() {
        }

        @Override
        public synchronized void write(char[] cbuf, int off, int len) {
            this.writer.write(cbuf, off, len);
        }

        public synchronized void startFlushing() {
            this.isFlushing = true;
            this.flush();
        }

        public void processClosed() {
            ConsolePseudoProcess consolePseudoProcess0 = this.consolePseudoProcess;
            if (consolePseudoProcess0 != null) {
                consolePseudoProcess0.fireTerminateEvent();
            }
        }
    }
}

