/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.internal.ui.TestRunnerViewPart;
import org.eclipse.unittest.model.ITestElement;

public class CopyFailureListAction
extends Action {
    private final Clipboard fClipboard;
    private final TestRunnerViewPart fRunner;

    public CopyFailureListAction(TestRunnerViewPart runner, Clipboard clipboard) {
        super(Messages.CopyFailureList_action_label);
        this.fRunner = runner;
        this.fClipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.unittest.ui.copy_failure_list_action_context");
    }

    public void run() {
        block3: {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.getAllFailureTraces()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fRunner.getSite().getShell(), (String)Messages.CopyFailureList_problem, (String)Messages.CopyFailureList_clipboard_busy)) break block3;
                this.run();
            }
        }
    }

    public String getAllFailureTraces() {
        StringBuilder buf = new StringBuilder();
        String lineDelim = System.lineSeparator();
        for (TestElement failure : this.fRunner.getCurrentTestRunSession().getAllFailedTestElements()) {
            String trace;
            buf.append(failure.getTestName()).append(lineDelim);
            ITestElement.FailureTrace failureTrace = failure.getFailureTrace();
            String string = trace = failureTrace != null ? failureTrace.getTrace() : null;
            if (trace == null) continue;
            int start = 0;
            while (start < trace.length()) {
                int idx = trace.indexOf(10, start);
                if (idx != -1) {
                    String line = trace.substring(start, idx);
                    buf.append(line).append(lineDelim);
                    start = idx + 1;
                    continue;
                }
                start = Integer.MAX_VALUE;
            }
        }
        return buf.toString();
    }
}

