/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.commands;

import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.console.ansi.preferences.AnsiConsolePreferenceUtils;
import org.eclipse.ui.menus.UIElement;

public class EnableDisableHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "AnsiConsole.command.enable_disable";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (EnableDisableHandler.wasMyEvent(event)) {
            boolean value = AnsiConsolePreferenceUtils.isAnsiConsoleEnabled();
            event.getCommand().getState("org.eclipse.ui.commands.toggleState").setValue((Object)value);
        } else {
            boolean value = !HandlerUtil.toggleCommandState((Command)event.getCommand());
            AnsiConsolePreferenceUtils.setAnsiConsoleEnabled(value);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        boolean ansiConsoleEnabled = AnsiConsolePreferenceUtils.isAnsiConsoleEnabled();
        element.setChecked(ansiConsoleEnabled);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand(COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        Boolean oldValue = (Boolean)state.getValue();
        if (!Objects.equals(ansiConsoleEnabled, oldValue)) {
            state.setValue((Object)ansiConsoleEnabled);
        }
    }

    private static boolean wasMyEvent(ExecutionEvent executionEvent) {
        Object trigger = executionEvent.getTrigger();
        if (trigger instanceof Event) {
            Event internalEvent = (Event)trigger;
            if (internalEvent.time == 0 && internalEvent.type == 0) {
                return true;
            }
        }
        return false;
    }
}

