/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.interpreter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.language.IInterpreterSourceViewer;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderRegistry;
import org.eclipse.swt.widgets.Composite;

public class SiriusInterpreterSourceViewer
extends SourceViewer
implements IInterpreterSourceViewer {
    private Collection<ContentProposal> computedProposals;

    public SiriusInterpreterSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
    }

    public Collection<ContentProposal> getComputedProposals() {
        return this.computedProposals;
    }

    public void showContentAssist(InterpreterContext context) {
        if (this.fContentAssistant == null) {
            return;
        }
        String expression = context.getExpression();
        if (expression != null && expression.length() != 0) {
            EObject target = context.getTargetEObjects().isEmpty() ? null : (EObject)context.getTargetEObjects().get(0);
            Session curSession = SessionManager.INSTANCE.getSession(target);
            IInterpreter vpInterpreter = curSession != null ? curSession.getInterpreter() : CompoundInterpreter.INSTANCE.getInterpreterForExpression(expression);
            ContentInstanceContext contentContext = new ContentInstanceContext(target, context.getExpression(), this.getSelectedRange().x);
            if (vpInterpreter instanceof IProposalProvider) {
                this.computedProposals = ((IProposalProvider)vpInterpreter).getProposals(vpInterpreter, contentContext);
            } else {
                this.computedProposals = new LinkedHashSet<ContentProposal>();
                List proposalProviders = ProposalProviderRegistry.getProvidersFor((IInterpreter)vpInterpreter);
                for (IProposalProvider provider : proposalProviders) {
                    this.computedProposals.addAll(provider.getProposals(vpInterpreter, contentContext));
                }
            }
        } else {
            this.computedProposals = CompoundInterpreter.INSTANCE.getAllNewEmtpyExpressions();
        }
        this.fContentAssistant.showPossibleCompletions();
        this.computedProposals = null;
    }
}

