/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.IToolBarContextService;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public abstract class SiriusTabbarExtensionContributionFactory
extends ExtensionContributionFactory {
    protected SiriusTabbarExtensionContributionFactory() {
    }

    protected boolean canEdit() {
        DDiagramEditor editor;
        boolean canEditInstance = true;
        if (this.getPart() != null && (editor = (DDiagramEditor)this.getPart()) != null && editor.getRepresentation() != null) {
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
            canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
        }
        return canEditInstance;
    }

    protected DDiagram getDDiagram() {
        DDiagramEditor editor = (DDiagramEditor)this.getPart();
        if (editor != null && editor.getRepresentation() instanceof DDiagram) {
            return (DDiagram)editor.getRepresentation();
        }
        return null;
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
    }

    protected IDiagramWorkbenchPart getPart() {
        return IToolBarContextService.INSTANCE.getPart();
    }

    protected IWorkbenchPage getPage() {
        return IToolBarContextService.INSTANCE.getPage();
    }

    protected ToolBarManager getManager() {
        return IToolBarContextService.INSTANCE.getMenuManager();
    }

    public static class TabbarActionContributionItem
    extends ActionContributionItem
    implements ISelectionListener {
        protected IWorkbenchPart representationPart;

        public TabbarActionContributionItem(IAction action, IWorkbenchPart part) {
            super(action);
            ISelectionService selectionService;
            this.representationPart = part;
            if (this.representationPart != null && (selectionService = (ISelectionService)this.representationPart.getSite().getService(ISelectionService.class)) != null) {
                selectionService.addSelectionListener((ISelectionListener)this);
            }
        }

        public TabbarActionContributionItem(IAction action) {
            super(action);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IWorkbenchPart effectivePart = part;
            if (this.representationPart != null && part != null && part.getAdapter(this.representationPart.getClass()) != null) {
                effectivePart = (IWorkbenchPart)part.getAdapter(this.representationPart.getClass());
            }
            if (this.representationPart != null && this.representationPart.equals(effectivePart)) {
                IAction action = this.getAction();
                if (action instanceof IActionDelegate) {
                    ((IObjectActionDelegate)action).selectionChanged(action, selection);
                } else if (action instanceof ISelectionListener) {
                    ((ISelectionListener)action).selectionChanged(effectivePart, selection);
                }
                this.update();
            }
        }

        public void dispose() {
            ISelectionService selectionService;
            super.dispose();
            if (this.representationPart != null && (selectionService = (ISelectionService)this.representationPart.getSite().getService(ISelectionService.class)) != null) {
                selectionService.removeSelectionListener((ISelectionListener)this);
            }
            this.representationPart = null;
            IAction action = this.getAction();
            if (action instanceof IDisposableAction) {
                ((IDisposableAction)action).dispose();
            } else if (action instanceof ActionFactory.IWorkbenchAction) {
                ((ActionFactory.IWorkbenchAction)action).dispose();
            } else if (action instanceof Disposable) {
                ((Disposable)action).dispose();
            }
        }
    }
}

