/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.messages.Messages;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public abstract class AbstractCommand<T>
implements Callable<T> {
    private IProgressMonitor progressMonitor;
    private static ExecutorService executors = Executors.newSingleThreadExecutor();
    private final ProxyConnection connection;

    private Future<T> asyncCmdInThread() throws ProxyException {
        return executors.submit(this);
    }

    public StreamChannel openChannel() throws IOException {
        return this.connection.openChannel();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public T getResult(IProgressMonitor monitor) throws ProxyException {
        Future<T> future = null;
        this.progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        future = this.asyncCmdInThread();
        return this.waitCmdInThread(future);
    }

    private T waitCmdInThread(Future<T> future) throws ProxyException {
        boolean bInterrupted = Thread.interrupted();
        while (!this.getProgressMonitor().isCanceled()) {
            try {
                return future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                bInterrupted = true;
            }
            catch (TimeoutException e) {
            }
            catch (ExecutionException e) {
                throw new ProxyException(e.getMessage());
            }
            this.getProgressMonitor().worked(1);
        }
        if (bInterrupted) {
            Thread.currentThread().interrupt();
        }
        future.cancel(true);
        throw new ProxyException(Messages.AbstractCommand_0);
    }

    @Override
    public abstract T call() throws ProxyException;

    public AbstractCommand(ProxyConnection conn) {
        this.connection = conn;
    }
}

