/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.actions.ProfilingMonitorActionGroup;
import org.eclipse.php.profile.ui.views.ProfilingMonitorContentProvider;
import org.eclipse.php.profile.ui.views.ProfilingMonitorElement;
import org.eclipse.php.profile.ui.views.ProfilingMonitorLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProfilingMonitorView
extends ViewPart
implements IProfileSessionListener,
IDoubleClickListener,
ISelectionChangedListener,
IMenuListener {
    private TreeViewer fViewer;
    private ProfilingMonitorActionGroup fActionSet;
    private Menu fContextMenu;

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent);
        this.fViewer.setContentProvider((IContentProvider)new ProfilingMonitorContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ProfilingMonitorLabelProvider());
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fActionSet = new ProfilingMonitorActionGroup(this.fViewer);
        this.fActionSet.fillActionBars(this.getViewSite().getActionBars());
        ProfileSessionsManager.addProfileSessionListener((IProfileSessionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.hookContextMenu();
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.profiling_monitor_view");
    }

    public void doubleClick(DoubleClickEvent event) {
        this.fActionSet.handlerDoubleClick(event);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fActionSet.updateSelectionDependentActions(event.getSelection());
    }

    public void setFocus() {
    }

    public void update() {
        if (this.fViewer == null || this.fViewer.getContentProvider() == null) {
            return;
        }
        ProfilerDB[] profilerDBs = ProfileSessionsManager.getSessions();
        ProfilingMonitorElement[] elements = new ProfilingMonitorElement[profilerDBs.length];
        int i = 0;
        while (i < profilerDBs.length) {
            elements[i] = new ProfilingMonitorElement(profilerDBs[i]);
            ++i;
        }
        this.fViewer.setInput((Object)elements);
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.fViewer.removeDoubleClickListener((IDoubleClickListener)this);
            this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        ProfileSessionsManager.removeProfileSessionListener((IProfileSessionListener)this);
        super.dispose();
    }

    public void profileSessionAdded(ProfilerDB db) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ProfilingMonitorView.this.update();
            }
        });
    }

    public void profileSessionRemoved(ProfilerDB db) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ProfilingMonitorView.this.update();
            }
        });
    }

    public void currentSessionChanged(ProfilerDB current) {
    }

    public void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fActionSet.fillContextMenu(manager);
    }
}

