/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.model.connection.MessageException;
import org.eclipse.php.phpunit.model.connection.PHPUnitMessageParser;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestEvent;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;

public class PHPUnitTestException
extends PHPUnitTestEvent {
    private static final String TOP_CLASS = "Exception";
    private String exceptionClass = "Exception";

    public PHPUnitTestException(MessageException exception, PHPUnitTest parent, RemoteDebugger remoteDebugger) {
        super(exception, (PHPUnitElement)parent, remoteDebugger);
        this.exceptionClass = exception.getClazz();
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public String toString() {
        return this.file + ":" + String.valueOf(this.line) + "$" + this.exceptionClass + "!" + this.message;
    }

    public static void addAbnormalException(PHPUnitTestCase testCase) {
        MessageException exception = new MessageException(PHPUnitMessages.PHPUnitTestException_0, PHPUnitMessages.PHPUnitTestException_1);
        PHPUnitTestException abnormalException = new PHPUnitTestException(exception, null, null);
        abnormalException.setParent(testCase);
        testCase.setException(abnormalException);
        testCase.setStatus(5);
        PHPUnitTestGroup parent = (PHPUnitTestGroup)testCase.getParent();
        if (parent != null) {
            parent.setStatus(testCase.getStatus());
        }
        PHPUnitMessageParser.getInstance().mapException(testCase, exception);
    }
}

