/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.builder;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathManager;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;

public class ComposerBuildPathManagementBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "org.eclipse.php.composer.core.builder.buildPathManagementBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        BuildPathManager buildPathManager;
        block10: {
            IResourceDelta delta;
            boolean changed;
            IComposerProject composerProject;
            block9: {
                IProject project;
                block8: {
                    project = this.getProject();
                    if (!FacetManager.hasComposerFacet(project)) {
                        return null;
                    }
                    composerProject = ComposerPlugin.getDefault().getComposerProject(project);
                    IFile composerJson = composerProject.getComposerJson();
                    if (composerJson != null && composerJson.exists()) break block8;
                    return null;
                }
                changed = false;
                delta = this.getDelta(project);
                buildPathManager = new BuildPathManager(composerProject);
                if (delta != null) break block9;
                buildPathManager.update(monitor);
                return null;
            }
            String vendor = composerProject.getVendorDir();
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta affected = iResourceDeltaArray[n2];
                String path = affected.getProjectRelativePath().toOSString();
                if (path.equals("composer.lock") || path.equals(vendor)) {
                    changed = true;
                }
                ++n2;
            }
            if (changed) break block10;
            return null;
        }
        try {
            buildPathManager.update(monitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return null;
    }
}

