/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.php.internal.server.core.builtin.PHPServerBehaviour;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings;
    private boolean stop = false;
    private String url;
    private IServer server;
    private PHPServerBehaviour behaviour;

    public PingThread(IServer server, String url, int maxPings, PHPServerBehaviour behaviour) {
        this.server = server;
        this.url = url;
        this.maxPings = maxPings;
        this.behaviour = behaviour;
        Thread t = new Thread("PHP Server Ping Thread"){

            @Override
            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)3, "Ping: could not stop server");
                    }
                    this.stop = true;
                    break;
                }
                Trace.trace((byte)3, "Ping: pinging " + ++count);
                URL pingUrl = new URL(this.url);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
                ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop) {
                    Trace.trace((byte)3, "Ping: success");
                    Thread.sleep(200L);
                    this.behaviour.setServerStarted();
                }
                this.stop = true;
            }
            catch (FileNotFoundException fe) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.behaviour.setServerStarted();
                this.stop = true;
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Ping: failed");
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() {
        Trace.trace((byte)3, "Ping: stopping");
        this.stop = true;
    }
}

