/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.filterSynthesis.FilterSynthesisImpl;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.AbstractTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.BranchingTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

public class VariableTracebackStep
extends BranchingTracebackStep<VariableExp> {
    private boolean identity = false;
    private final Variable variable;
    private final OppositeEndFinder oppositeEndFinder;
    private final boolean variableHasCollectionType;

    public VariableTracebackStep(VariableExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        super(sourceExpression, tupleLiteralNamesToLookFor, tracebackStepCache.getOppositeEndFinder(), operationBodyToCallMapper, unusedEvaluationRequestFactory, oclFactory);
        this.oppositeEndFinder = tracebackStepCache.getOppositeEndFinder();
        this.variable = (Variable)sourceExpression.getReferredVariable();
        this.variableHasCollectionType = this.variable.getType() instanceof CollectionType;
        tracebackStepCache.put((OCLExpression)sourceExpression, tupleLiteralNamesToLookFor, this);
        if (this.isSelf()) {
            this.getSteps().addAll(this.tracebackSelf(sourceExpression, context, tracebackStepCache, operationBodyToCallMapper, tupleLiteralNamesToLookFor));
        } else if (this.isIteratorVariable()) {
            this.getSteps().addAll(this.tracebackIteratorVariable(sourceExpression, context, tracebackStepCache, operationBodyToCallMapper, tupleLiteralNamesToLookFor));
        } else if (this.isIterateResultVariable()) {
            this.getSteps().addAll(this.tracebackIterateResultVariable(sourceExpression, context, tracebackStepCache, operationBodyToCallMapper, tupleLiteralNamesToLookFor));
        } else if (this.isLetVariable()) {
            this.getSteps().addAll(this.tracebackLetVariable(sourceExpression, context, tracebackStepCache, operationBodyToCallMapper, tupleLiteralNamesToLookFor));
        } else if (this.isOperationParameter()) {
            this.getSteps().addAll(this.tracebackOperationParameter(sourceExpression, context, tracebackStepCache, operationBodyToCallMapper, tupleLiteralNamesToLookFor));
        } else {
            throw new RuntimeException("Unknown variable expression that is neither an iterator variable nor an iterate result variable nor an operation parameter nor a let variable nor self: " + this.variable.getName());
        }
    }

    @Override
    protected OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        OperationCallExpKeyedSet result;
        if (pendingUnusedEvalRequests != null && !this.variableHasCollectionType) {
            UnusedEvaluationRequestSet.UnusedEvaluationResult unusedResult = pendingUnusedEvalRequests.setVariable(this.variable, source.getAnnotatedObject(), this.oppositeEndFinder, tracebackCache, this.oclFactory);
            if (unusedResult.hasProvenUnused()) {
                ++provenUnused;
                result = tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
            } else {
                result = this.perform(source, unusedResult.getNewRequestSet(), tracebackCache, changeEvent);
            }
        } else {
            result = this.perform(source, null, tracebackCache, changeEvent);
        }
        return result;
    }

    private OperationCallExpKeyedSet perform(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        OperationCallExpKeyedSet result = this.identity ? tracebackCache.getOperationCallExpKeyedSetFactory().createOperationCallExpKeyedSet(source) : super.performSubsequentTraceback(source, pendingUnusedEvalRequests, tracebackCache, changeEvent);
        return result;
    }

    private boolean isLetVariable() {
        return this.variable.eContainer() instanceof LetExp && ((LetExp)this.variable.eContainer()).getVariable() == this.variable;
    }

    private boolean isOperationParameter() {
        return this.variable.getRepresentedParameter() != null;
    }

    private boolean isIterateResultVariable() {
        return this.variable.eContainer() instanceof IterateExp && ((IterateExp)this.variable.eContainer()).getResult() == this.variable;
    }

    private boolean isIteratorVariable() {
        return this.variable.eContainer() instanceof LoopExp && ((LoopExp)this.variable.eContainer()).getIterator().contains((Object)this.variable);
    }

    private boolean isSelf() {
        return this.variable.getName().equals("self");
    }

    private Set<AbstractTracebackStep.TracebackStepAndScopeChange> tracebackOperationParameter(VariableExp variableExp, EClass context, TracebackStepCache tracebackStepCache, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor) {
        HashSet<AbstractTracebackStep.TracebackStepAndScopeChange> result = new HashSet<AbstractTracebackStep.TracebackStepAndScopeChange>();
        OCLExpression rootExpression = this.getRootExpression((OCLExpression)variableExp);
        EOperation op = (EOperation)operationBodyToCallMapper.getCallsOf(rootExpression).iterator().next().getReferredOperation();
        int pos = this.getParameterPosition(op);
        for (OperationCallExp call : operationBodyToCallMapper.getCallsOf(rootExpression)) {
            OCLExpression argumentExpression = (OCLExpression)call.getArgument().get(pos);
            AbstractTracebackStep.TracebackStepAndScopeChangeWithOperationCallExp stepWithScopeChange = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, argumentExpression, call, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
            result.add(stepWithScopeChange);
        }
        return result;
    }

    private int getParameterPosition(EOperation op) {
        return op.getEParameters().indexOf(this.variable.getRepresentedParameter());
    }

    private Set<AbstractTracebackStep.TracebackStepAndScopeChange> tracebackLetVariable(VariableExp variableExpression, EClass context, TracebackStepCache tracebackStepCache, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor) {
        OCLExpression initExpression = (OCLExpression)this.variable.getInitExpression();
        AbstractTracebackStep.TracebackStepAndScopeChange step = this.createTracebackStepAndScopeChange((OCLExpression)variableExpression, initExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
        return Collections.singleton(step);
    }

    private Set<AbstractTracebackStep.TracebackStepAndScopeChange> tracebackIterateResultVariable(VariableExp variableExp, EClass context, TracebackStepCache tracebackStepCache, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor) {
        AbstractTracebackStep.TracebackStepAndScopeChange stepForInitExpression = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, (OCLExpression)this.variable.getInitExpression(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
        AbstractTracebackStep.TracebackStepAndScopeChange stepForBodyExpression = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, (OCLExpression)((IterateExp)variableExp.getReferredVariable().eContainer()).getBody(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
        HashSet<AbstractTracebackStep.TracebackStepAndScopeChange> result = new HashSet<AbstractTracebackStep.TracebackStepAndScopeChange>();
        result.add(stepForBodyExpression);
        result.add(stepForInitExpression);
        return result;
    }

    private Set<AbstractTracebackStep.TracebackStepAndScopeChange> tracebackIteratorVariable(VariableExp variableExp, EClass context, TracebackStepCache tracebackStepCache, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor) {
        Set<AbstractTracebackStep.TracebackStepAndScopeChange> result;
        LoopExp loopExp = (LoopExp)variableExp.getReferredVariable().eContainer();
        OCLExpression source = (OCLExpression)loopExp.getSource();
        AbstractTracebackStep.TracebackStepAndScopeChange stepForSource = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, source, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
        if ("closure".equals(loopExp.getName())) {
            AbstractTracebackStep.TracebackStepAndScopeChange stepForBody = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, (OCLExpression)loopExp.getBody(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
            result = new HashSet<AbstractTracebackStep.TracebackStepAndScopeChange>();
            result.add(stepForSource);
            result.add(stepForBody);
        } else {
            result = Collections.singleton(stepForSource);
        }
        return result;
    }

    private Set<AbstractTracebackStep.TracebackStepAndScopeChange> tracebackSelf(VariableExp variableExp, EClass context, TracebackStepCache tracebackStepCache, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor) {
        HashSet<AbstractTracebackStep.TracebackStepAndScopeChange> result;
        OCLExpression rootExpression = this.getRootExpression((OCLExpression)variableExp);
        EOperation op = this.getOperationOfWhichRootExpressionIsTheBody(rootExpression, operationBodyToCallMapper);
        Collection derivedPropertyCalls = ((FilterSynthesisImpl)operationBodyToCallMapper).getDerivedProperties().get(rootExpression);
        if (op != null) {
            result = new HashSet();
            Set<OperationCallExp> calls = operationBodyToCallMapper.getCallsOf(rootExpression);
            for (OperationCallExp call : calls) {
                OCLExpression callSource = (OCLExpression)call.getSource();
                AbstractTracebackStep.TracebackStepAndScopeChangeWithOperationCallExp stepForCall = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, callSource, call, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
                result.add(stepForCall);
            }
        } else if (derivedPropertyCalls != null) {
            result = new HashSet();
            for (PropertyCallExp call : derivedPropertyCalls) {
                OCLExpression callSource = (OCLExpression)call.getSource();
                AbstractTracebackStep.TracebackStepAndScopeChange stepForCall = this.createTracebackStepAndScopeChange((OCLExpression)variableExp, callSource, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
                result.add(stepForCall);
            }
        } else {
            this.identity = true;
            result = Collections.emptySet();
        }
        return result;
    }

    private EOperation getOperationOfWhichRootExpressionIsTheBody(OCLExpression potentialBody, OperationBodyToCallMapper operationBodyToCallMapper) {
        Set<OperationCallExp> filterSynthesizerCallCache = operationBodyToCallMapper.getCallsOf(potentialBody);
        EOperation op = null;
        if (!filterSynthesizerCallCache.isEmpty()) {
            op = (EOperation)filterSynthesizerCallCache.iterator().next().getReferredOperation();
        }
        return op;
    }

    protected OCLExpression getRootExpression(OCLExpression e) {
        return OclHelper.getRootExpression((EObject)e);
    }
}

