/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class SaxOrphanBuilder {
    private final Document document = this.createDocument();
    private Element currentElement;
    private StringBuilder currentStringContent;
    private final Element orphansElement = this.document.getDocumentElement();

    private Document createDocument() throws CoreException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element root = document.createElement("orphans");
            document.appendChild(root);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to create document", (Throwable)e));
        }
    }

    public void startElement(String localName, Attributes attributes) {
        Element element = this.document.createElement(localName);
        int i = 0;
        while (i < attributes.getLength()) {
            String attributeName = attributes.getLocalName(i);
            String attributeValue = attributes.getValue(i);
            element.setAttribute(attributeName, attributeValue);
            ++i;
        }
        if (this.currentElement != null) {
            this.appendTextNode();
            this.currentElement.appendChild(element);
        }
        this.currentElement = element;
        this.currentStringContent = new StringBuilder();
    }

    public void acceptCharacters(char[] content, int start, int length) {
        if (this.currentStringContent != null) {
            this.currentStringContent.append(content, start, length);
        }
    }

    public void endElement() {
        if (this.currentElement != null) {
            this.appendTextNode();
            Node parentNode = this.currentElement.getParentNode();
            if (parentNode instanceof Element && parentNode != this.orphansElement) {
                this.currentElement = (Element)parentNode;
                this.currentStringContent = new StringBuilder();
            } else {
                this.currentElement = null;
                this.currentStringContent = null;
            }
        }
    }

    public void commitOrphan() {
        if (this.currentElement != null) {
            this.document.getDocumentElement().appendChild(this.currentElement);
        }
    }

    private void appendTextNode() {
        if (this.hasStringContnet()) {
            Text textNode = this.document.createTextNode(this.currentStringContent.toString());
            this.currentElement.appendChild(textNode);
        }
    }

    private boolean hasStringContnet() {
        return this.currentStringContent != null & this.currentStringContent.length() > 0;
    }

    public Document getOrphans() {
        return this.document;
    }
}

