/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.ecore.composite;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.modisco.facet.widgets.celleditors.ecore.Activator;
import org.eclipse.modisco.facet.widgets.celleditors.ecore.ui.MultiLineDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class StringMultiComposite<T>
extends AbstractCellEditorComposite<String> {
    private final Button button;
    private Text text = null;
    private final Composite parentControl;
    private String originalFieldValue;

    public StringMultiComposite(Composite parent, Object originalValue, int style) {
        super(parent);
        this.parentControl = parent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData data = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)data);
        if (originalValue != null) {
            if (originalValue instanceof String) {
                this.setValue((String)originalValue);
                this.text.setSelection(0, ((String)originalValue).length());
            } else {
                Logger.logError((String)"An instance of String was expected", (Plugin)Activator.getDefault());
            }
        }
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiLineDialog dialog = new MultiLineDialog(StringMultiComposite.this.getParentControl().getShell(), StringMultiComposite.this.getValue()){

                    @Override
                    protected void okPressed() {
                        StringMultiComposite.this.originalFieldValue = this.getTextArea().getText();
                        StringMultiComposite.this.getText().setText(this.getTextArea().getText());
                        StringMultiComposite.this.commit();
                        super.okPressed();
                    }
                };
                dialog.open();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == StringMultiComposite.this.getParentControl().getShell() && event.widget != StringMultiComposite.this.getButton() && event.widget != StringMultiComposite.this.getText()) {
                    if (StringMultiComposite.this.getText().getEditable()) {
                        StringMultiComposite.this.commit();
                    } else {
                        StringMultiComposite.this.close();
                    }
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (StringMultiComposite.this.getText().getEditable()) {
                        StringMultiComposite.this.commit();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    StringMultiComposite.this.close();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringMultiComposite.this.fireChanged();
            }
        });
        this.text.forceFocus();
    }

    public StringMultiComposite(Composite parent, int style) {
        this(parent, null, style);
    }

    public StringMultiComposite(Composite parent, Object originalValue) {
        this(parent, originalValue, 0);
    }

    protected void commit() {
        this.fireCommit();
    }

    public void setValue(String value) {
        this.originalFieldValue = value;
        if (value == null) {
            this.text.setText("");
        } else if (value.indexOf(10) != -1) {
            String truncatedValue = value.substring(0, value.indexOf(10) - 1).concat("...");
            this.text.setText(truncatedValue);
            this.text.setEditable(false);
        } else {
            this.text.setText(value);
            this.text.setSelection(0, value.length());
        }
    }

    public String getValue() {
        if (this.text.getEditable()) {
            return this.text.getText();
        }
        return this.getOriginalFieldValue();
    }

    public Button getButton() {
        return this.button;
    }

    public Composite getParentControl() {
        return this.parentControl;
    }

    public String getOriginalFieldValue() {
        return this.originalFieldValue;
    }

    protected Text getText() {
        return this.text;
    }
}

