/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.internal.snapshot.SnapshotArgument;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.TestSuite;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryHistory;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizard;
import org.eclipse.mat.ui.snapshot.ParseHeapDumpJob;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class QueryExecution {
    public static void executeAgain(MultiPaneEditor editor, PaneState state) throws SnapshotException {
        ArgumentSet argumentSet = CommandLine.parse((IQueryContext)editor.getQueryContext(), (String)state.getIdentifier());
        QueryExecution.execute(editor, state.getParentPaneState(), state, argumentSet, false, true);
    }

    public static void executeCommandLine(MultiPaneEditor editor, PaneState originator, String commandLine) throws SnapshotException {
        ArgumentSet argumentSet = CommandLine.parse((IQueryContext)editor.getQueryContext(), (String)commandLine);
        QueryExecution.execute(editor, originator, null, argumentSet, false, true);
    }

    public static void executeCommandLine(MultiPaneEditor editor, PaneState originator, String commandLine, boolean prompt) throws SnapshotException {
        ArgumentSet argumentSet = CommandLine.parse((IQueryContext)editor.getQueryContext(), (String)commandLine);
        QueryExecution.execute(editor, originator, null, argumentSet, prompt, true);
    }

    public static void executeQuery(MultiPaneEditor editor, QueryDescriptor query) throws SnapshotException {
        ArgumentSet argumentSet = query.createNewArgumentSet(editor.getQueryContext());
        QueryExecution.execute(editor, null, null, argumentSet, true, true);
    }

    public static void execute(MultiPaneEditor editor, PaneState originator, PaneState stateToReopen, ArgumentSet set, boolean forcePrompt, boolean isReproducable) {
        boolean promptUser = forcePrompt;
        if (!set.isExecutable()) {
            promptUser = true;
        }
        if (promptUser && !QueryExecution.promp(editor, set, forcePrompt)) {
            return;
        }
        String cmdLine = set.writeToLine();
        if (isReproducable) {
            QueryHistory.addQuery(cmdLine);
        }
        ExecutionJob job = new ExecutionJob(editor, originator, stateToReopen, cmdLine, set, isReproducable);
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    private static boolean promp(MultiPaneEditor editor, ArgumentSet arguments, boolean prompt) {
        boolean hasUserArguments = false;
        boolean hasEditableArguments = false;
        for (ArgumentDescriptor arg : arguments.getQueryDescriptor().getArguments()) {
            hasUserArguments = hasUserArguments || arguments.getArgumentValue(arg) == null || (arg.getType() == Boolean.class || arg.getType() == Boolean.TYPE) && Boolean.FALSE.equals(arguments.getArgumentValue(arg));
            hasEditableArguments |= !editor.getQueryContext().available(arg.getType(), arg.getAdvice()) && !(arguments.getArgumentValue(arg) instanceof HeapObjectContextArgument);
        }
        if (hasUserArguments || prompt && hasEditableArguments) {
            ArgumentsWizard wizard = new ArgumentsWizard(editor.getQueryContext(), arguments);
            WizardDialog dialog = new WizardDialog(editor.getSite().getShell(), (IWizard)wizard);
            dialog.setHelpAvailable(true);
            dialog.setBlockOnOpen(true);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.mat.ui.query.arguments");
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                return false;
            }
        }
        return true;
    }

    public static void displayResult(final MultiPaneEditor editor, final PaneState originator, final PaneState stateToReopen, QueryResult result, final boolean isReproducable) {
        if (result.getSubject() instanceof CompositeResult) {
            CompositeResult composite = (CompositeResult)result.getSubject();
            if (composite.asHtml()) {
                result = QueryExecution.convertToHtml(editor, result, composite);
            }
        } else if (result.getSubject() instanceof Spec) {
            result = QueryExecution.convertToHtml(editor, result, (Spec)result.getSubject());
        }
        final QueryResult r = result;
        editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryExecution.doDisplayResult(editor, originator, stateToReopen, r, isReproducable);
            }
        });
    }

    private QueryExecution() {
    }

    private static void doDisplayResult(MultiPaneEditor editor, PaneState originator, PaneState stateToReopen, QueryResult result, boolean isReproducable) {
        if (result.getSubject() instanceof CompositeResult) {
            List results = ((CompositeResult)result.getSubject()).getResultEntries();
            for (CompositeResult.Entry r : results) {
                QueryResult qr = r.getResult() instanceof CompositeResult && ((CompositeResult)r.getResult()).asHtml() ? QueryExecution.convertToHtml(editor, result, (CompositeResult)r.getResult()) : (r.getResult() instanceof Spec ? QueryExecution.convertToHtml(editor, result, (Spec)r.getResult()) : new QueryResult(result, result.getQuery(), result.getCommand(), r.getResult()));
                QueryExecution.doDisplayResult(editor, originator, stateToReopen, qr, isReproducable);
            }
        } else {
            IResult subject = result.getSubject();
            AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane(subject, null);
            if (stateToReopen == null) {
                if (originator != null && originator.getType() == PaneState.PaneType.COMPOSITE_PARENT) {
                    for (PaneState child : originator.getChildren()) {
                        if (!child.isActive()) continue;
                        originator = child;
                        break;
                    }
                }
                PaneState state = pane instanceof CompositeHeapEditorPane ? new PaneState(PaneState.PaneType.COMPOSITE_PARENT, originator, pane.getTitle(), false) : new PaneState(PaneState.PaneType.QUERY, originator, result.getCommand(), isReproducable);
                state.setImage(MemoryAnalyserPlugin.getDefault().getImage(result.getQuery()));
                pane.setPaneState(state);
            } else {
                pane.setPaneState(stateToReopen);
            }
            editor.addNewPage(pane, (Object)result, result.getTitle(), MemoryAnalyserPlugin.getDefault().getImage(result.getQuery()));
        }
    }

    private static QueryResult convertToHtml(MultiPaneEditor editor, QueryResult result, CompositeResult composite) {
        String name = composite.getName() != null ? composite.getName() : result.getTitle();
        SectionSpec section = new SectionSpec(name);
        int count = 1;
        for (CompositeResult.Entry r : composite.getResultEntries()) {
            String label = r.getName();
            if (label == null) {
                label = String.valueOf(result.getCommand()) + " " + count;
            }
            QuerySpec spec = new QuerySpec(label);
            spec.setResult(r.getResult());
            section.add((Spec)spec);
            ++count;
        }
        return QueryExecution.convertToHtml(editor, result, (Spec)section);
    }

    private static QueryResult convertToHtml(MultiPaneEditor editor, QueryResult result, Spec section) {
        try {
            TestSuite suite = new TestSuite.Builder(section).build(editor.getQueryContext());
            suite.execute((IProgressListener)new VoidProgressListener());
            for (File f : suite.getResults()) {
                if (!"index.html".equals(f.getName())) continue;
                return new QueryResult(result.getQuery(), result.getCommand(), (IResult)new DisplayFileResult(f));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(String.valueOf(section.getName()) + Messages.QueryExecution_NoHTMLOutput);
    }

    private static class ExecutionJob
    extends Job {
        MultiPaneEditor editor;
        ArgumentSet argumentSet;
        PaneState originator;
        PaneState stateToReopen;
        boolean isReproducable;

        public ExecutionJob(MultiPaneEditor editor, PaneState originator, PaneState stateToReopen, String name, ArgumentSet argumentSet, boolean isReproducable) {
            super(name);
            this.editor = editor;
            this.originator = originator;
            this.stateToReopen = stateToReopen;
            this.argumentSet = argumentSet;
            this.isReproducable = isReproducable;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                QueryResult result;
                ArrayList<ISnapshot> secondarySnapshots = new ArrayList<ISnapshot>();
                this.preloadSnapshots(secondarySnapshots, monitor);
                try {
                    result = this.argumentSet.execute((IProgressListener)new ProgressMonitorWrapper(monitor));
                }
                finally {
                    this.disposePreloadedSnapshots(secondarySnapshots);
                }
                if (result != null && result.getSubject() != null) {
                    QueryExecution.displayResult(this.editor, this.originator, this.stateToReopen, result, this.isReproducable);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                ErrorHelper.showInfoMessage(Messages.QueryExecution_NoResult);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (e instanceof IProgressListener.OperationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = ErrorHelper.createErrorStatus(e);
                return iStatus;
            }
            finally {
                monitor.done();
                this.cleanup();
            }
        }

        private List<ISnapshot> preloadSnapshots(List<ISnapshot> snapshots, IProgressMonitor mon) throws SnapshotException, InterruptedException {
            for (ArgumentDescriptor arg : this.argumentSet.getQueryDescriptor().getArguments()) {
                if (arg.getAdvice() != Argument.Advice.SECONDARY_SNAPSHOT) continue;
                Object value = this.argumentSet.getArgumentValue(arg);
                if (value instanceof SnapshotArgument) {
                    SnapshotArgument sa = (SnapshotArgument)value;
                    this.preloadSnapshot(mon, snapshots, sa);
                    continue;
                }
                if (!arg.isList()) continue;
                List source = (List)value;
                int ii = 0;
                while (ii < source.size()) {
                    Object v = source.get(ii);
                    if (v instanceof SnapshotArgument) {
                        SnapshotArgument sa = (SnapshotArgument)v;
                        this.preloadSnapshot(mon, snapshots, sa);
                    }
                    ++ii;
                }
            }
            return snapshots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preloadSnapshot(IProgressMonitor mon, final List<ISnapshot> snapshots, SnapshotArgument sa) throws InterruptedException {
            Path snappath = new Path(sa.getFilename());
            int size = snapshots.size();
            ParseHeapDumpJob job = new ParseHeapDumpJob((IPath)snappath, this.editor.getSite().getShell().getDisplay()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void finished(ISnapshot snapshot) {
                    List list = snapshots;
                    synchronized (list) {
                        snapshots.add(snapshot);
                        snapshots.notifyAll();
                    }
                }
            };
            job.setUser(true);
            job.setPriority(30);
            job.schedule();
            job.join(Long.MAX_VALUE, mon);
            IStatus status = job.getResult();
            if (status != null && status.isOK()) {
                int count = 3;
                List<ISnapshot> list = snapshots;
                synchronized (list) {
                    while (snapshots.size() == size && count++ < 3) {
                        snapshots.wait(10000L);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disposePreloadedSnapshots(List<ISnapshot> secondarySnapshots) {
            List<ISnapshot> list = secondarySnapshots;
            synchronized (list) {
                for (ISnapshot snapshot : secondarySnapshots) {
                    SnapshotFactory.dispose((ISnapshot)snapshot);
                }
            }
        }

        private void cleanup() {
            this.editor = null;
            this.originator = null;
            this.stateToReopen = null;
            this.argumentSet = null;
        }
    }
}

